/**
File:		MachineLearning/Models/GPModels/FgDeepGPBaseModel.h

Author:		
Email:		
Site:       

Copyright (c) 2017 . All rights reserved.
*/

#pragma once

#include <MachineLearning/FgIModel.h>
#include <MachineLearning/FgLikelihoodBaseLayer.h>
#include <MachineLearning/FgGPBaseLayer.h>

namespace NeuralEngine
{
	namespace MachineLearning
	{
		namespace GPModels
		{
			namespace PowerEP
			{
				template<typename Scalar>
				class SGPLayer;
			}

			namespace AEP
			{
				template<typename Scalar>
				class SGPLayer;
			}

			namespace VFE
			{
				//template<Scalar>
				class SGPLayer;
			}

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	
			/// 	Base class with abstract and basic function definitions. All deep GP models will be derived 
			/// 	from this class.			
			/// </summary>
			///
			/// <remarks>	HmetalT, 26.10.2017. </remarks>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			template<typename Scalar>
			class NE_IMPEXP DeepGPBaseModel : public GPBaseModel<Scalar>
			{
			public:

				////////////////////////////////////////////////////////////////////////////////////////////////////
				/// <summary>	Constructor. </summary>
				///
				/// <remarks>	, 26.03.2018. </remarks>
				///
				/// <param name="Y">		  	The data af::array to process. </param>
				/// <param name="X">		  	The training inputs. </param>
				/// <param name="hiddenLayerdescription">	The description for one hidden layer. </param>
				/// <param name="lType">	  	(Optional) the loglik type. </param>
				////////////////////////////////////////////////////////////////////////////////////////////////////
				DeepGPBaseModel(const af::array& Y, HiddenLayerDescription hiddenLayerdescription, LogLikType lType = LogLikType::Gaussian);

				////////////////////////////////////////////////////////////////////////////////////////////////////
				/// <summary>	Constructor. </summary>
				///
				/// <remarks>	, 26.03.2018. </remarks>
				///
				/// <param name="Y">		   	The data af::array to process. </param>
				/// <param name="X">		   	The training inputs. </param>
				/// <param name="hiddenLayerdescriptions">	The hidden layer descriptions. </param>
				/// <param name="lType">	   	(Optional) the loglik type. </param>
				////////////////////////////////////////////////////////////////////////////////////////////////////
				DeepGPBaseModel(const af::array& Y, std::vector<HiddenLayerDescription> descriptions, LogLikType lType = LogLikType::Gaussian);

				////////////////////////////////////////////////////////////////////////////////////////////////////
				/// <summary>	Default Constructor. </summary>
				///
				/// <remarks>	Hmetal T, 29.11.2017. </remarks>
				///
				////////////////////////////////////////////////////////////////////////////////////////////////////
				DeepGPBaseModel();

				////////////////////////////////////////////////////////////////////////////////////////////////////
				/// <summary>	Destructor. </summary>
				///
				/// <remarks>	, 23.04.2018. </remarks>
				////////////////////////////////////////////////////////////////////////////////////////////////////
				virtual ~DeepGPBaseModel();

				////////////////////////////////////////////////////////////////////////////////////////////////////
				/// <summary>	Predict noise free functions values \f$\mathbf{F}_*\f$. </summary>
				///
				/// <remarks>	Hmetal T, 05/05/2020. </remarks>
				///
				/// <param name="testInputs">	The test inputs. </param>
				/// <param name="mf">		 	[in,out] mean of function values. </param>
				/// <param name="vf">		 	[in,out] The variance of function values. </param>
				////////////////////////////////////////////////////////////////////////////////////////////////////
				virtual void PredictF(const af::array& testInputs, af::array& mf, af::array& vf) override;

				////////////////////////////////////////////////////////////////////////////////////////////////////
				/// <summary>	Generate function samples from posterior. </summary>
				/////
				/// <remarks>	Hmetal T, 18/06/2019. </remarks>
				///
				/// <param name="outFunctions">	[in,out] The out functions. </param>
				/// <param name="inputs">	   	The inputs. </param>
				/// <param name="numSamples">  	Number of samples. </param>
				////////////////////////////////////////////////////////////////////////////////////////////////////
				virtual void SampleY(const af::array inputs, int numSamples, af::array& outFunctions) override;

				////////////////////////////////////////////////////////////////////////////////////////////////////
				/// <summary>	Gets number of parameters. </summary>
				///
				/// <remarks>	, 26.06.2018. </remarks>
				///
				/// <returns>	The number parameters. </returns>
				////////////////////////////////////////////////////////////////////////////////////////////////////
				virtual int GetNumParameters() override;

				////////////////////////////////////////////////////////////////////////////////////////////////////
				/// <summary>	Gets number of GP layers. </summary>
				/// 
				/// <remarks>	Hmetal T, 09/07/2019. </remarks>
				///
				/// <returns>	The number layers. </returns>
				////////////////////////////////////////////////////////////////////////////////////////////////////
				virtual int GetNumLayers();

				////////////////////////////////////////////////////////////////////////////////////////////////////
				/// <summary>	Sets the parameters for each optimization iteration. </summary>
				///
				/// <remarks>	, 26.06.2018. </remarks>
				///
				/// <param name="param">	The parameter. </param>
				////////////////////////////////////////////////////////////////////////////////////////////////////
				virtual void SetParameters(const af::array& param) override;

				////////////////////////////////////////////////////////////////////////////////////////////////////
				/// <summary>	Gets the parameters for each optimization iteration. </summary>
				///
				/// <remarks>	, 26.06.2018. </remarks>
				///
				/// <param name="param">	The parameter. </param>
				////////////////////////////////////////////////////////////////////////////////////////////////////
				virtual af::array GetParameters() override;

				////////////////////////////////////////////////////////////////////////////////////////////////////
				/// <summary>	Updates the parameters. </summary>
				///
				/// <remarks>	, 26.06.2018. </remarks>
				////////////////////////////////////////////////////////////////////////////////////////////////////
				virtual void UpdateParameters() override;

				////////////////////////////////////////////////////////////////////////////////////////////////////
				/// <summary>	Gets vector of GP layers. </summary>
				///
				/// <remarks>	HmetalT, 09/07/2019. </remarks>
				///
				/// <returns>	null if it fails, else the gp layers. </returns>
				////////////////////////////////////////////////////////////////////////////////////////////////////
				virtual std::vector<GPBaseLayer<Scalar>*> GetGPLayers();

				////////////////////////////////////////////////////////////////////////////////////////////////////
				/// <summary>	Sets fixation for hyperparameters. </summary>
				///
				/// <remarks>	Hmetal T, 16/12/2019. </remarks>
				///
				/// <param name="isfixed">	True if isfixed. </param>
				////////////////////////////////////////////////////////////////////////////////////////////////////
				virtual void FixKernelParameters(bool isfixed);

			protected:
				int iNumLayer;					//< number of gp layers

				std::vector<int> vNumPseudosPerLayer;
				std::vector<int> vSize;

				std::vector<GPBaseLayer<Scalar>*> gpLayer;

			private:
				friend class boost::serialization::access;

				friend class AEP::SGPLayer<Scalar>;
				friend class PowerEP::SGPLayer<Scalar>;
				//friend class VFE::SGPLayer/*<Scalar>*/;

				template<class Archive>
				void serialize(Archive& ar, unsigned int version)
				{
					ar& boost::serialization::base_object<GPBaseModel<Scalar>>(*this);

					//ar& boost::serialization::make_nvp("GPBaseModel", boost::serialization::base_object<GPBaseModel<Scalar>>(*this));

					ar.register_type<AEP::SGPLayer<Scalar>>();
					ar.register_type<PowerEP::SGPLayer<Scalar>>();
					/*ar.register_type<VFE::SGPLayer>();*/

					ar& BOOST_SERIALIZATION_NVP(gpLayer);
					ar& BOOST_SERIALIZATION_NVP(iNumLayer);
					ar& BOOST_SERIALIZATION_NVP(vNumPseudosPerLayer);
					ar& BOOST_SERIALIZATION_NVP(vSize);
				}
			};
		}
	}
}
