/**
File:		MachineLearning/Graph/Graph/FgDiscreteGraph.h

Author:		
Email:		
Site:       

Copyright (c) 2017 . All rights reserved.
*/

#pragma once

#include <MachineLearning/FgIGraph.h>
#include <MachineLearning/FgDiscreteFactorNode.h>
#include <MachineLearning/FgDiscreteVariableNode.h>

namespace NeuralEngine
{
	namespace MachineLearning
	{
		class NE_IMPEXP DiscreteGraph : public IGraph<DiscreteFactorNode, DiscreteVariableNode>
		{
		public:
			DiscreteGraph(std::vector<DiscreteFactorNode*> &factorNodes);
			~DiscreteGraph();

			void ComputeMarginal(int numIter, double tolerance = 1e-6f);

		private:
			friend class boost::serialization::access;

			template<class Archive>
			void serialize(Archive& ar, unsigned int version)
			{
				ar & boost::serialization::base_object<IGraph>(*this);
				//ar & mNodes & sIncomming & sOutgoing & mMessageBox & sName & iId;
			}
		};
	}
}