/**
File:		MachineLearning/Graph/Node/FgDiscreteVariableNode.h

Author:		
Email:		
Site:       

Copyright (c) 2017 . All rights reserved.
*/

#pragma once

#include <MachineLearning/FgIVariableNode.h>
#include <MachineLearning/CommonUtil.h>

namespace NeuralEngine
{
	namespace MachineLearning
	{
		////////////////////////////////////////////////////////////////////////////////////////////////////
		/// <summary>	Class Discrete Variable Node. </summary>
		///
		/// <remarks>
		/// 	Basic functionalities of a Node in a Factor Graph.
		/// 		
		/// 	 Admin, 7/24/2017. 
		/// </remarks>
		////////////////////////////////////////////////////////////////////////////////////////////////////
		class NE_IMPEXP DiscreteVariableNode : public IVariableNode
		{
		public:

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Constructor. </summary>
			///
			/// <remarks>	Hmetal T, 09.08.2017. </remarks>
			///
			/// <param name="name">			The name. </param>
			/// <param name="ID">			The identifier. </param>
			/// <param name="numStates">	Number of states. </param>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			DiscreteVariableNode(std::string name, int numStates);

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Destructor. </summary>
			///
			/// <remarks>	 Admin, 7/24/2017. </remarks>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			~DiscreteVariableNode();

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Query if message type is supported. </summary>
			///
			/// <remarks>	 Admin, 7/25/2017. </remarks>
			///
			/// <param name="type">	The message type. </param>
			///
			/// <returns>	true if supported, false if not. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			virtual bool IsSupported(MsgType type);

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Query if this object is leaf node. </summary>
			///
			/// <remarks>	Hmetal T, 07.08.2017. </remarks>
			///
			/// <returns>	true if leaf node, false if not. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			bool IsLeafNode();

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Marginal propability of the node. </summary>
			///
			/// <remarks>	Hmetal T, 07.08.2017. </remarks>
			///
			/// <param name="neededMessages">	[in,out] The needed messages. </param>
			///
			/// <returns>	A reference to an af::array. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			virtual af::array& Marginal(MsgBox& neededMessages);

		protected:
			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Custom message computation for specific node. </summary>
			///
			/// <remarks>	 Admin, 8/15/2017. </remarks>
			///
			/// <param name="toNodeName">		 	Identifier for receiver node. </param>
			/// <param name="neededMessages">	All incomming messages, exept from receiver node. </param>
			///
			/// <returns>	An IMessage. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			virtual IMessage ComputeMessage(std::string toNodeName, MsgBox& neededMessages);

		private:
			friend class boost::serialization::access;

			template<class Archive>
			void serialize(Archive& ar, unsigned int version)
			{
				ar & boost::serialization::base_object<IVariableNode>(*this);
			}
		};
	}
}
