/**
File:		MachineLearning/Graph/Node/FgIFactorNode.cpp

Author:		
Email:		
Site:       

Copyright (c) 2017 . All rights reserved.
*/

#pragma once

#include <MachineLearning/FgIVariableNode.h>
#include <MachineLearning/FgIMessage.h>

namespace NeuralEngine
{
	namespace MachineLearning
	{
		class NE_IMPEXP IFactorNode : public INode
		{
		public:

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Constructor. </summary>
			///
			/// <remarks>	 Admin, 8/30/2017. </remarks>
			///
			/// <param name="node">	[in,out] The corresponding variable node. </param>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			IFactorNode(IVariableNode &node);

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Constructor. </summary>
			///
			/// <remarks>	 Admin, 8/16/2017. </remarks>
			///
			/// <param name="node">	[in,out] The corresponding variable node. </param>
			/// <param name="name">	The name. </param>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			IFactorNode(IVariableNode &node, std::string name);

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Constructor. </summary>
			///
			/// <remarks>	 Admin, 8/30/2017. </remarks>
			///
			/// <param name="nodes">	[in,out] If non-null, the corresponding variable nodes. </param>
			/// <param name="name"> 	The name. </param>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			template<class T>
			IFactorNode(std::vector<T*> nodes, std::string name)
				: INode(name) 
			{
				for (int i = 0; i < nodes.size(); i++)
					mNodes.insert(std::make_pair(nodes[i]->Name(), nodes[i]));
			}

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Constructor. </summary>
			///
			/// <remarks>	 Admin, 8/30/2017. </remarks>
			///
			/// <param name="nodes">	[in,out] If non-null, the corresponding variable nodes. </param>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			template<class T>
			IFactorNode(std::vector<T*> nodes)
				: IFactorNode(nodes, CreateName(nodes)) {}

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Destructor. </summary>
			///
			/// <remarks>	 Admin, 8/16/2017. </remarks>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			~IFactorNode();

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Query if message type is supported. </summary>
			///
			/// <remarks>	 Admin, 7/25/2017. </remarks>
			///
			/// <param name="type">	The type. </param>
			///
			/// <returns>	true if supported, false if not. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			virtual bool IsSupported(MsgType type) = 0;

		protected:
			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Calculates a message to connectd node. </summary>
			///
			/// <remarks>
			/// 	 Admin, 7/26/2017. 
			/// </remarks>
			///
			/// <param name="toNodeName">		 	Identifier for receiver node. </param>
			/// <param name="neededMessages">	All incomming messages, exept from receiver node. </param>
			///
			/// <returns>	The calculated message. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			virtual IMessage ComputeMessage(std::string toNodeName, MsgBox &neededMessages) = 0;

		private:

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Creates a name for the node, if no name is given. </summary>
			///
			/// <remarks>	 Admin, 8/30/2017. </remarks>
			///
			/// <param name="nodes">	[in,out] [in,out] If non-null, the nodes. </param>
			///
			/// <returns>	The new name. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			template<class T>
			std::string CreateName(std::vector<T*> &nodes)
			{
				std::string name = "P";
				for (int i = 0; i < nodes.size(); i++)
					name += "_" + nodes[i]->Name();

				return name;
			}

			friend class boost::serialization::access;

			template<class Archive>
			void serialize(Archive& ar, unsigned int version)
			{
				ar & boost::serialization::base_object<INode>(*this);
				//ar & mNodes & sIncomming & sOutgoing & mMessageBox & sName & iId;
			}
		};
	}
}