/**
File:		MachineLearning/GPModels/Models/Layers/LikLayers/FgILikelihoodLayer.h

Author:		
Email:		
Site:       

Copyright (c) 2017 . All rights reserved.
*/

#pragma once

#undef min
#undef max

#include <NeMachineLearningLib.h>
#include <MachineLearning/CommonUtil.h>


namespace NeuralEngine
{
	namespace MachineLearning
	{
		enum class LayerType
		{
			LogLik,
			GP,
			Emission // emission layer for SSM
		};

		////////////////////////////////////////////////////////////////////////////////////////////////////
		/// <summary>	Abstract class for different kind of layers. </summary>
		///
		/// <remarks>	, 27.02.2018. </remarks>
		////////////////////////////////////////////////////////////////////////////////////////////////////
		template<typename Scalar>
		class NE_IMPEXP ILayer
		{
		public:

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Constructor. </summary>
			///
			/// <remarks>	, 26.06.2018. </remarks>
			///
			/// <param name="type">			The type. </param>
			/// <param name="numPoints">	Number of points. </param>
			/// <param name="outputDim">	The output dim. </param>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			ILayer(LayerType type, int numPoints, int outputDim)
				: lType(type), iN(numPoints), iD(outputDim), m_dType(CommonUtil<Scalar>::CheckDType()) { }

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Destructor. </summary>
			///
			/// <remarks>	, 26.06.2018. </remarks>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			virtual ~ILayer() = default;

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Gets the layer type. </summary>
			///
			/// <remarks>	, 26.06.2018. </remarks>
			///
			/// <returns>	The type. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			LayerType GetType() { return lType; }

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Gets number of parameters to be optimized. </summary>
			///
			/// <remarks>	, 26.06.2018. </remarks>
			///
			/// <returns>	The number parameters. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			virtual int GetNumParameters() = 0;

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Sets the parameters for each optimization iteration. </summary>
			///
			/// <remarks>	, 26.06.2018. </remarks>
			///
			/// <param name="param">	The parameter. </param>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			virtual void SetParameters(const af::array& param) = 0;

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Gets the parameters for each optimization iteration. </summary>
			///
			/// <remarks>	, 26.06.2018. </remarks>
			///
			/// <returns>	The parameters. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			virtual af::array GetParameters() = 0;

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Updates the parameters. </summary>
			///
			/// <remarks>	, 26.06.2018. </remarks>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			virtual void UpdateParameters() = 0;

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Sets data size. </summary>
			///
			/// <remarks>	Hmetal T, 03/09/2020. </remarks>
			///
			/// <param name="length">   	The length. </param>
			/// <param name="dimension">	The dimension. </param>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			virtual void SetDataSize(int length, int dimension)
			{
				iN = length;
				iD = dimension;
			}

		protected:

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Default constructor. </summary>
			///
			/// <remarks>	, 26.06.2018. </remarks>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			ILayer() { }

			int iD;	//!< data dimension
			int iN;	//!< data size

			LayerType lType; //!< liklihood or gp layer

			af::dtype m_dType;	//!< floating point precision flag for af::array

		private:
			friend class boost::serialization::access;

			template<class Archive>
			void serialize(Archive& ar, unsigned int version)
			{
				ar& BOOST_SERIALIZATION_NVP(iD);
				ar& BOOST_SERIALIZATION_NVP(iN);
				ar& BOOST_SERIALIZATION_NVP(lType);
				ar& BOOST_SERIALIZATION_NVP(m_dType);

				/*layertype_serializer a1(lType);
				ar & boost::serialization::make_nvp("LayerType", a1);*/
			}
		};
		
	}
}
