/**
File:		MachineLearning/Graph/Message/FgIMessage.h

Author:		
Email:		
Site:       

Copyright (c) 2017 . All rights reserved.
*/

#pragma once

#include <NeMachineLearningLib.h>
#include <map>

namespace NeuralEngine
{
	namespace MachineLearning
	{
		enum MsgType
		{
			eDiscreteMessage = 0,
			eGaussianMessage
		};

		class NE_IMPEXP IMessage
		{
		public:

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Constructor. </summary>
			///
			/// <remarks>	 Admin, 7/25/2017. </remarks>
			///
			/// <param name="type">	The type. </param>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			IMessage(MsgType type);

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Destructor. </summary>
			///
			/// <remarks>	 Admin, 7/25/2017. </remarks>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			~IMessage();

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Gets the message type. </summary>
			///
			/// <remarks>	 Admin, 7/25/2017. </remarks>
			///
			/// <returns>	The type. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			MsgType GetType();

		private:
			MsgType eType;
		};

		typedef std::map<std::string, IMessage> MsgBox;
	}
}
