/**
File:		MachineLearning/Graph/Node/FgIVariableNode.h

Author:		
Email:		
Site:       

Copyright (c) 2017 . All rights reserved.
*/

#pragma once

#include <MachineLearning/FgINode.h>
#include <MachineLearning/FgIMessage.h>

namespace NeuralEngine
{
	namespace MachineLearning
	{
		class NE_IMPEXP IVariableNode : public INode
		{
		public:

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Constructor. </summary>
			///
			/// <remarks>	 Admin, 8/16/2017. </remarks>
			///
			/// <param name="name">	The name. </param>
			/// <param name="ID">  	The identifier. </param>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			IVariableNode(std::string name, int numStates);

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Destructor. </summary>
			///
			/// <remarks>	 Admin, 8/16/2017. </remarks>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			~IVariableNode();

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Gets the dimension of the node. </summary>
			///
			/// <remarks>	 Admin, 8/31/2017. </remarks>
			///
			/// <returns>	An int. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			int NumStates();

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Query if message type is supported. </summary>
			///
			/// <remarks>	 Admin, 7/25/2017. </remarks>
			///
			/// <param name="type">	The type. </param>
			///
			/// <returns>	true if supported, false if not. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			virtual bool IsSupported(MsgType type) = 0;

		protected:
			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Calculate a message to connectd node. </summary>
			///
			/// <remarks>	
			/// 	Different computations for all kinds of derived classes of node types.
			/// 	
			/// 	 Admin, 7/26/2017. 
			/// </remarks>
			///
			/// <param name="toNodeName">		 	Identifier for receiver node. </param>
			/// <param name="neededMessages">	All incomming messages, exept from receiver node. </param>
			///
			/// <returns>	The calculated message. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			virtual IMessage ComputeMessage(std::string toNodeName, MsgBox &neededMessages) = 0;

		private:
			int iNumStates;

			friend class boost::serialization::access;

			template<class Archive>
			void serialize(Archive& ar, unsigned int version)
			{
				ar & boost::serialization::base_object<INode>(*this);
				ar& BOOST_SERIALIZATION_NVP(iNumStates);
			}
		};
	}
}
