/**
File:		MachineLearning/Embed/PCA.h

Author:		
Email:		
Site:       

Copyright (c) 2017 . All rights reserved.
*/

#pragma once

#include <MachineLearning/IEmbed.h>

namespace NeuralEngine
{
	namespace MachineLearning
	{
		////////////////////////////////////////////////////////////////////////////////////////////////////
		/// <summary>	Pirincipal Component Analyses. </summary>
		/// 
		/// <remarks>
		///		Principal component analysis (PCA) is a statistical procedure that uses an orthogonal 
		///		transformation to convert a set of observations of possibly correlated variables into 
		///		a set of values of linearly uncorrelated variables called principal components (or 
		///		sometimes, principal modes of variation). The number of principal components is less 
		///		than or equal to the smaller of the number of original variables or the number of 
		///		observations. This transformation is defined in such a way that the first principal 
		///		component has the largest possible variance (that is, accounts for as much of the 
		///		variability in the data as possible), and each succeeding component in turn has the 
		///		highest variance possible under the constraint that it is orthogonal to the preceding 
		///		components. The resulting vectors are an uncorrelated orthogonal basis set. PCA is 
		///		sensitive to the relative scaling of the original variables.
		/// </remarks>
		////////////////////////////////////////////////////////////////////////////////////////////////////
		class NE_IMPEXP PCA : public IEmbed
		{
		public:

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Default constructor. </summary>
			///
			/// <remarks>	Hmetal T, 02/12/2019. </remarks>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			PCA() { }

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Computes the first q components </summary>
			///
			/// <remarks>	Hmetal T, 11.04.2017. </remarks>
			///
			/// <param name="M">	[in,out] N by D data matrix. </param>
			/// <param name="q">	Number of components. </param>
			///
			/// <returns>	An af::array. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			af::array Compute(af::array& M, int q);
		};
	}
}
