﻿/**
File:		MachineLearning/GPModels/Models/GPModels/FgPEPSparseGPLVM.h

Author:		
Email:		
Site:       

Copyright (c) 2018 . All rights reserved.
*/

#pragma once

#include <MachineLearning/FgSparseGPBaseModel.h>

namespace NeuralEngine
{
	namespace MachineLearning
	{
		namespace GPModels
		{
			namespace PowerEP
			{
				/////////////////////////////////////////////////////////////////////////////////////////////////
				/// <summary>	
				/// 	Sparse Gaussian Process Latent Variable Model (SGPLVM) with optimization
				/// 	through Power Expectation Propagation (PEP). 
				/// </summary>
				///
				/// <remarks>
				/// 	PEP, as an extention of EP, minimizes a α-divergence. It is equivalent
				/// 	to minimizing KL-divergence with the exact distribution raised to a power. PEP can be seen
				/// 	as a hybrid between the regular EP (α = 1) and variational inference (Variational Free 
				/// 	Energy (VFE)) (α = 0).
				/// 	
				/// 	For more information see, 
				/// 	https://www.microsoft.com/en-us/research/wp-content/uploads/2016/02/tr-2004-149.pdf
				/// 		
				/// 	, 28.02.2018. 
				/// </remarks>
				////////////////////////////////////////////////////////////////////////////////////////////////////
				template<typename Scalar>
				class NE_IMPEXP SGPLVM : SparseGPBaseModel<Scalar>
				{
				public:

				protected:

				private:
					friend class boost::serialization::access;

					template<class Archive>
					void serialize(Archive& ar, unsigned int version)
					{
						ar& boost::serialization::base_object<SparseGPBaseModel<Scalar>>(*this);
						//ar& boost::serialization::make_nvp("SparseGPBaseModel", boost::serialization::base_object<SparseGPBaseModel<Scalar>>(*this));
						//ar & ik & aX;
					}
				};
			}
		}
	}
}
