﻿/**
File:		MachineLearning/GPModels/Models/GPModels/FgPEPSparseGPR.h

Author:		
Email:		
Site:       

Copyright (c) 2018 . All rights reserved.
*/

#pragma once

#include <MachineLearning/FgSparseGPBaseModel.h>
#include <MachineLearning/FgPEPSparseGPLayer.h>

namespace NeuralEngine
{
	namespace MachineLearning
	{
		namespace GPModels
		{
			namespace PowerEP
			{
				/////////////////////////////////////////////////////////////////////////////////////////////////
				/// <summary>	
				/// 	Sparse Gaussian Process Regression (SGPR) with optimization
				/// 	through Power Expectation Propagation (PEP). 
				/// </summary>
				///
				/// <remarks>
				/// 	PEP, as an extention of EP, minimizes a α-divergence. It is equivalent
				/// 	to minimizing KL-divergence with the exact distribution raised to a power. PEP can be seen
				/// 	as a hybrid between the regular EP (α = 1) and variational inference (Variational Free 
				/// 	Energy (VFE)) (α = 0).
				/// 	
				/// 	For more information see, 
				/// 	https://www.microsoft.com/en-us/research/wp-content/uploads/2016/02/tr-2004-149.pdf
				///		https://arxiv.org/pdf/1605.07066.pdf
				/// 		
				/// 	, 28.02.2018. 
				/// </remarks>
				////////////////////////////////////////////////////////////////////////////////////////////////////
				template<typename Scalar>
				class NE_IMPEXP SGPR : public SparseGPBaseModel<Scalar>
				{
				public:

					////////////////////////////////////////////////////////////////////////////////////////////////////
					/// <summary>	Constructor. </summary>
					///
					/// <remarks>	, 12.06.2018. </remarks>
					///
					/// <param name="Y">		  	The training data. </param>
					/// <param name="X">		  	The training inputs. </param>
					/// <param name="numInducing">	(Optional) number of inducing inputs. </param>
					/// <param name="lType">	  	(Optional) likelihood type. </param>
					////////////////////////////////////////////////////////////////////////////////////////////////////
					SGPR(const af::array& Y, const af::array& X, int numInducing = 20, LogLikType lType = LogLikType::Gaussian);

					////////////////////////////////////////////////////////////////////////////////////////////////////
					/// <summary>	Inference. </summary>
					///
					/// <remarks>	
					/// 	Running the PowerEP algorithm to optimize posterior.
					/// 	
					/// 	, 12.06.2018. 
					/// </remarks>
					///
					/// <param name="alpha">		 	(Optional) the alpha. </param>
					/// <param name="numIter">		 	(Optional) number of iterators. </param>
					/// <param name="parallelUpdate">	(Optional) true to parallel update. </param>
					/// <param name="decay">		 	(Optional) the decay. </param>
					////////////////////////////////////////////////////////////////////////////////////////////////////
					void Inference(Scalar alpha = 1.0, int numIter = 10, bool parallelUpdate = false, Scalar decay = 0.5);

				protected:
					SGPR();

				private:
					friend class boost::serialization::access;

					template<class Archive>
					void serialize(Archive& ar, unsigned int version)
					{
						ar& boost::serialization::base_object<SparseGPBaseModel<Scalar>>(*this);
						//ar& boost::serialization::make_nvp("SparseGPBaseModel", boost::serialization::base_object<SparseGPBaseModel<Scalar>>(*this));
						//ar & ik & aX;
					}
				};
			}
		}
	}
}

