/**
File:		MachineLearning/Graph/Misc/FgPotential.h

Author:		
Email:		
Site:       

Copyright (c) 2017 . All rights reserved.
*/

#pragma once

#include <NeMachineLearningLib.h>
#include <vector>

namespace NeuralEngine
{
	namespace MachineLearning
	{
		////////////////////////////////////////////////////////////////////////////////////////////////////
		/// <summary>
		///		It is simply a std::vector with an interface designed for
		///		dealing with probability mass functions. It is a flattend version of an D dimensional 
		///		propability table.
		/// 	
		///		It is mainly used for representing measures on a finite outcome space, for example, the
		///		probability distribution of a discrete random variable. However, entries are not
		///		necessarily non-negative; it is also used to represent logarithms of probability mass
		///		functions.
		/// </summary>
		///
		/// <remarks>	Hmetal T, 11.08.2017. </remarks>
		///
		/// <typeparam name="T">
		/// 	Should be a scalar and should support elementary arithmetic operations.
		/// </typeparam>
		////////////////////////////////////////////////////////////////////////////////////////////////////
		class NE_IMPEXP Potential
		{
		public:

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Default constructor. </summary>
			///
			/// <remarks>	 Admin, 8/29/2017. </remarks>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			Potential();

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Destructor. </summary>
			///
			/// <remarks>	 Admin, 8/29/2017. </remarks>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			~Potential();

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Adds a potential value. </summary>
			///
			/// <remarks>	 Admin, 8/29/2017. </remarks>
			///
			/// <param name="value">	The value to add. </param>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			void Add(double value);

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Sets a potential value at given index. </summary>
			///
			/// <remarks>	 Admin, 8/29/2017. </remarks>
			///
			/// <param name="value">	The value. </param>
			/// <param name="index">	Zero-based index of the value. </param>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			void Set(double value, int index);

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Gets a potential value using the given index. </summary>
			///
			/// <remarks>	 Admin, 8/29/2017. </remarks>
			///
			/// <param name="index">	The index to get. </param>
			///
			/// <returns>	A double. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			double Get(int index);

		private:
			std::vector<double> vP;	// all probability combinations of a factor node
		};
	}
}