/**
File:		MachineLearning/Models/GPModels/FgSparseDeepGPBaseModel.h

Author:		
Email:		
Site:       

Copyright (c) 2017 . All rights reserved.
*/

#pragma once

#include <MachineLearning/FgDeepGPBaseModel.h>

namespace NeuralEngine
{
	namespace MachineLearning
	{
		namespace GPModels
		{

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	
			/// 	Base class with abstract and basic function definitions. All deep GP models will be derived 
			/// 	from this class.			
			/// </summary>
			///
			/// <remarks>	HmetalT, 26.10.2017. </remarks>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			template<typename Scalar>
			class NE_IMPEXP SparseDeepGPBaseModel : public DeepGPBaseModel<Scalar>
			{
			public:

				////////////////////////////////////////////////////////////////////////////////////////////////////
				/// <summary>	Constructor. </summary>
				///
				/// <remarks>	, 26.03.2018. </remarks>
				///
				/// <param name="Y">		  	The data af::array to process. </param>
				/// <param name="X">		  	The training inputs. </param>
				/// <param name="hiddenLayerdescription">	The description for one hidden layer. </param>
				/// <param name="lType">	  	(Optional) the loglik type. </param>
				////////////////////////////////////////////////////////////////////////////////////////////////////
				SparseDeepGPBaseModel(const af::array& Y, const af::array& X, HiddenLayerDescription hiddenLayerdescription, LogLikType lType = LogLikType::Gaussian);

				////////////////////////////////////////////////////////////////////////////////////////////////////
				/// <summary>	Constructor. </summary>
				///
				/// <remarks>	, 26.03.2018. </remarks>
				///
				/// <param name="Y">		   	The data af::array to process. </param>
				/// <param name="X">		   	The training inputs. </param>
				/// <param name="hiddenLayerdescriptions">	The hidden layer descriptions. </param>
				/// <param name="lType">	   	(Optional) the loglik type. </param>
				////////////////////////////////////////////////////////////////////////////////////////////////////
				SparseDeepGPBaseModel(const af::array& Y, const af::array& X, std::vector<HiddenLayerDescription> hiddenLayerdescriptions, LogLikType lType = LogLikType::Gaussian);

				////////////////////////////////////////////////////////////////////////////////////////////////////
				/// <summary>	Default Constructor. </summary>
				///
				/// <remarks>	Hmetal T, 29.11.2017. </remarks>
				///
				////////////////////////////////////////////////////////////////////////////////////////////////////
				SparseDeepGPBaseModel();

				////////////////////////////////////////////////////////////////////////////////////////////////////
				/// <summary>	Destructor. </summary>
				///
				/// <remarks>	, 23.04.2018. </remarks>
				////////////////////////////////////////////////////////////////////////////////////////////////////
				virtual ~SparseDeepGPBaseModel();

				////////////////////////////////////////////////////////////////////////////////////////////////////
				/// <summary>	Initializes the model. </summary>
				///
				/// <remarks>	Hmetal T, 29.11.2017. </remarks>
				///
				/// <returns>	true if it succeeds, false if it fails. </returns>
				////////////////////////////////////////////////////////////////////////////////////////////////////
				virtual bool Init() override;

				////////////////////////////////////////////////////////////////////////////////////////////////////
				/// <summary>	Gets training inputs. </summary>
				///
				/// <remarks>	Hmetal T, 17/09/2019. </remarks>
				///
				/// <returns>	The training inputs. </returns>
				////////////////////////////////////////////////////////////////////////////////////////////////////
				af::array GetTrainingInputs();

				////////////////////////////////////////////////////////////////////////////////////////////////////
				/// <summary>	Set fixation for inducing inputs. </summary>
				///
				/// <remarks>	Hmetal T, 16/12/2019. </remarks>
				///
				/// <param name="isfixed">	True if isfixed. </param>
				////////////////////////////////////////////////////////////////////////////////////////////////////
				virtual void FixInducing(bool isfixed);

			protected:
				int iq;							//< latent dimension
				af::array afX;					//< training inputs

			private:
				friend class boost::serialization::access;

				template<class Archive>
				void serialize(Archive& ar, unsigned int version)
				{
					ar& boost::serialization::base_object<DeepGPBaseModel<Scalar>>(*this);

					//ar& boost::serialization::make_nvp("DeepGPBaseModel", boost::serialization::base_object<DeepGPBaseModel<Scalar>>(*this));

					ar& BOOST_SERIALIZATION_NVP(iq);
					ar& BOOST_SERIALIZATION_NVP(afX);
				}
			};
		}
	}
}
