/**
File:		MachineLearning/Optimization/Unconstrained/Linesearch/FgArmijoBracketingLineSearch.h

Author:		
Email:		
Site:       

Copyright (c) 2019 . All rights reserved.
*/

#pragma once

#include <MachineLearning/FgILineSearch.h>

namespace NeuralEngine
{
	namespace MachineLearning
	{
		////////////////////////////////////////////////////////////////////////////////////////////////////
		/// <summary>	Strong Wolfe. </summary>
		///
		/// <remarks>
		/// 			
		/// 	HmetalT, 10/06/2019. 
		/// </remarks>
		////////////////////////////////////////////////////////////////////////////////////////////////////
		template<typename Scalar>
		class NE_IMPEXP StrongWolfeBracketingLineSearch : public ILineSearch<Scalar>
		{
		public:

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Linesearches. </summary>
			///
			/// <remarks>	Hmetal T, 10/06/2019. </remarks>
			///
			/// <param name="x">			  	The af::array to process. </param>
			/// <param name="searchDirection">	The search direction. </param>
			/// <param name="prob">			  	[in,out] The prob. </param>
			/// <param name="alpha0">		  	The alpha 0. </param>
			///
			/// <returns>	A Scalar. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			void Linesearch(NonlinearObjectiveFunction<Scalar>& objFunc, Scalar& fx, af::array& x, af::array& grad, Scalar& step, const af::array& drt, const af::array& xp) override;

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Destructor. </summary>
			///
			/// <remarks>	Hmetal T, 11/06/2019. </remarks>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			~StrongWolfeBracketingLineSearch() { }
		};
	}
}

