/**
File:		MachineLearning/Optimization/Base/IGradientOptimizationMethod.h

Author:		
Email:		
Site:       

Copyright (c) 2017 . All rights reserved.
*/

#pragma once

#include <MachineLearning/IOptimizationMethod.h>
#include <MachineLearning/FgILineSearch.h>
#include <functional>

namespace NeuralEngine
{
	namespace MachineLearning
	{
		////////////////////////////////////////////////////////////////////////////////////////////////////
		/// <summary>
		/// 	Common interface for function optimization methods which depend on having both an
		/// 	objective function and a gradient function definition available.
		/// </summary>
		///
		/// <remarks>	HmetalT, 16.03.2017. </remarks>
		///
		/// <seealso cref="BroydenFletcherGoldfarbShanno"/>
		/// <seealso cref="ConjugateGradient"/>
		/// <seealso cref="ResilientBackpropagation"/>
		////////////////////////////////////////////////////////////////////////////////////////////////////
		template<typename Scalar>
		class IGradientOptimizationMethod : public IOptimizationMethod<Scalar>
		{
		public:

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>
			/// 	Gets a function returning the gradient vector of the function to be optimized for a given
			/// 	value of its free parameters.
			/// </summary>
			///
			/// <remarks>	HmetalT, 16.03.2017. </remarks>
			///
			/// <returns>	The gradient function. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			virtual af::array GetGradient() = 0;

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Sets a function returning the gradient vector of the function to be optimized for a given
			/// 	value of its free parameters. </summary>
			///
			/// <remarks>	HmetalT, 16.03.2017. </remarks>
			///
			/// <param name="parameter1">	The first parameter. </param>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			virtual void SetGradient(af::array g) = 0;

		protected:
			

		};
	}
}