/**
File:		MachineLearning/Optimization/IObjectiveFunction.h

Author:		
Email:		
Site:       

Copyright (c) 2017 . All rights reserved.
*/

#pragma once

#include <NeMachineLearningLib.h>
#include <MachineLearning/CommonUtil.h>
#include <map>
#include <string>
#include <functional>


namespace NeuralEngine
{
	namespace MachineLearning
	{
		template<typename Scalar>
		class NE_IMPEXP IObjectiveFunction
		{
			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Gets the number of input variables for the function. </summary>
			///
			/// <remarks>	Hmetal T, 18.03.2017. </remarks>
			///
			/// <returns>	The number of variables. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			virtual int GetNumberOfVariables() = 0;

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Gets the objective function. </summary>
			///
			/// <remarks>	Hmetal T, 18.03.2017. </remarks>
			///
			/// <returns>	The function. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			virtual std::function<Scalar(const af::array&, af::array&)> GetFunction() = 0;
		};
	}
}
