from algorithms import Algorithms
from environment import Environment
import numpy as np
import fire
from tqdm import tqdm
import numpy as np


def run_experiment(epsilon, T, price_mult, prod_num, exp_duration, algorithm="baseline"):
    N = prod_num + 2
    k = 4 + 1

    p = np.ones(N) * price_mult
    p[0] = 0
    p[1] = 0

    delay_threshold = 500
    mean_return_delay = 100
    upper_bound_delay = T
    skew = 'left'

    v_cv = np.zeros(N)
    for i in range(N):
        if i in [2, 3, 9, 10]:
            v_cv[i] = 0.25 + epsilon
        elif i == 0:
            v_cv[i] = 1
        else:
            v_cv[i] = 0.25

    alg = Algorithms(T=T, N=N, k=k, p=p, delay_threshold=delay_threshold, mean_return_delay=mean_return_delay,
                     upper_bound_delay=upper_bound_delay, skew=skew, v_cv=v_cv)

    optimal_revenue, S_star = alg.clairvoyant()

    if algorithm == "baseline":
        total_revenue, total_sales, E_i_e, S_e_bin = alg.exp(exp_duration=int(T ** exp_duration))
    elif algorithm == "demba":
        total_revenue, total_sales, E_i_e, S_e_bin = alg.demba(0, 1.33, 0, 0)
    else:
        raise ValueError("Invalid algorithm name. Choose 'baseline' or 'demba'.")

    regret = optimal_revenue - total_revenue


    return regret, optimal_revenue, total_revenue, total_sales, E_i_e, S_e_bin


epsilon = 0.05
price_mult = 1
delay_threshold_mult = 1
prod_num = 10

# T_values = [1000, 2000, 4000, 6000, 8000, 10000, ]
T_values = np.linspace(2000, 20000, 10)

number_of_simulations = 20

for T in T_values:
    res = np.zeros((4, number_of_simulations))
    total_rev = np.zeros((4, number_of_simulations))
    optimal_rev = np.zeros((4, number_of_simulations))

    for iter in tqdm(range(number_of_simulations), desc=f"Processing T={T}"):


        for i, exp_duration_value in enumerate([0.86, 0.88, 0.9]):
            np.random.seed(iter)
            regret, optimal_revenue, total_revenue, _, _, _ = run_experiment(
                epsilon, T, price_mult, delay_threshold_mult, prod_num, exp_duration_value, algorithm="baseline"
            )

            res[i, iter] = regret
            total_rev[i, iter] = optimal_revenue
            optimal_rev[i, iter] = total_revenue

        np.random.seed(iter)
        regret, optimal_revenue, total_revenue, _, _, _ = run_experiment(
            epsilon, T, price_mult, delay_threshold_mult, prod_num, 0, algorithm="demba"
        )
        res[3, iter] = regret
        total_rev[3, iter] = optimal_revenue
        optimal_rev[3, iter] = total_revenue

    filename_ret = "value_" + str(T)
    folder = "experiments/500100/"

    filename = "res_" + filename_ret
    np.save(folder + filename + '.npy', res)
    filename = "rev_" + filename_ret
    np.save(folder + filename + '.npy', total_rev)
    filename = "optrev_" + filename_ret
    np.save(folder + filename + '.npy', optimal_rev)





