import networkx as nx
import matplotlib.pyplot as plt
from copy import deepcopy
import numpy as np
import random

def opt_off(s_init, h_r, sp, L = -10000):

    logging = False
    # create a new graph
    G_dash = nx.DiGraph()

    ##############
    # ADD NODES
    ##############
    # add source and sink
    G_dash.add_node('source')
    G_dash.add_node('sink')
    for i in range(len(h_r)):
        G_dash.add_node(str(i))
        G_dash.add_node(str(i) + '_dash')

    # add the initial locations of the servers.
    for i in s_init:
        G_dash.add_node('s_start_' + str(i))

    ##############
    # ADD EDGES
    ##############

    # first, connect source to initial server locations
    for i in s_init:
        G_dash.add_edges_from([
            ('source', 's_start_' + str(i), {"capacity": 1, "weight": 0}),
        ])

    # connect each server to each request: this only potentially enables service,
    # we are not saying that each server goes to each request
    for i in s_init:
        for j in range(len(h_r)):
            G_dash.add_edges_from([
                ('s_start_' + str(i), str(j), {"capacity": 1, "weight": sp[i][h_r[j]]})
            ])

    # connect r and r'
    for i in range(len(h_r)):
        G_dash.add_edges_from([
            (str(i), str(i) + '_dash', {"capacity": 1, "weight": L})
        ])

    # connect each r'_t1 to r'_t2 if t1<t2, i.e., if t1 arrived before t2
    for i in range(len(h_r)):
        for j in range(i + 1, len(h_r)):
            G_dash.add_edges_from([
                (str(i) + '_dash', str(j), {"capacity": 1, "weight": sp[h_r[i]][h_r[j]]})
            ])

    # connect each r' to sink
    for i in range(len(h_r)):
        G_dash.add_edges_from([
            (str(i) + '_dash', 'sink', {"capacity": 1, "weight": 0})
        ])

    # connect each s_init to sink
    for i in s_init:
        G_dash.add_edges_from([
            ('s_start_' + str(i), 'sink', {"capacity": 1, "weight": 0})
        ])

    # return the offline opt term + the online opt term
    if logging:
        print("Offline Cost is: {}".format(
            nx.cost_of_flow(G_dash, nx.max_flow_min_cost(G_dash, 'source', 'sink')) - (len(h_r) * L)))
    return nx.cost_of_flow(G_dash, nx.max_flow_min_cost(G_dash, 'source', 'sink')) - (len(h_r) * L)