import os
import pickle
import json
import pandas as pd

# Set the base directory where the files are located
base_dir = '/data/home/ifb5104/K_server_RL/data/emergency_response/'

# List of files to process with full paths
files = [
    os.path.join(base_dir, 'cell_map.pickle'),
    os.path.join(base_dir, 'cluster_output_1_r.pickle'),
    os.path.join(base_dir, 'cluster_output_2_r.pickle'),
    os.path.join(base_dir, 'cluster_output_3_r.pickle'),
    os.path.join(base_dir, 'cluster_output_4_r.pickle'),
    os.path.join(base_dir, 'cluster_output_5_r.pickle'),
    os.path.join(base_dir, 'cluster_output_6_r.pickle'),
    os.path.join(base_dir, 'cluster_output_7_r.pickle'),
    os.path.join(base_dir, 'cluster_output_8_r.pickle'),
    os.path.join(base_dir, 'cluster_output_9_r.pickle'),
    os.path.join(base_dir, 'depots_with_cells.json'),
    os.path.join(base_dir, 'hospital_locations.csv'),
    os.path.join(base_dir, 'jan_feb_travel_times.parquet'),
    os.path.join(base_dir, 'non_stationary_chains.pickle'),
    os.path.join(base_dir, 'non_stationary_rates.pickle'),
    os.path.join(base_dir, 'valid_cells_out.pickle')
]

# Function to load pickle files
def load_pickle(file_path):
    with open(file_path, 'rb') as f:
        return pickle.load(f)

# Function to load json files
def load_json(file_path):
    with open(file_path, 'r') as f:
        return json.load(f)

# Function to load csv files
def load_csv(file_path):
    return pd.read_csv(file_path)

# Function to load parquet files
def load_parquet(file_path):
    return pd.read_parquet(file_path)

# Loop through files and load their contents
for file in files:
    print(f"Processing {file}...")

    try:
        # Check the file extension to determine how to load the file
        if file.endswith('.pickle'):
            data = load_pickle(file)
            print(f"{file} loaded. Data type: {type(data)}")
            print(f"Summary: {data}\n")
        
        elif file.endswith('.json'):
            data = load_json(file)
            print(f"{file} loaded. Data type: {type(data)}")
            print(f"Summary: {data}\n")
        
        elif file.endswith('.csv'):
            data = load_csv(file)
            print(f"{file} loaded. Data type: {type(data)}")
            print(f"Columns: {data.columns}\n")
            print(f"Sample data:\n{data.head()}\n")
        
        elif file.endswith('.parquet'):
            data = load_parquet(file)
            print(f"{file} loaded. Data type: {type(data)}")
            print(f"Columns: {data.columns}\n")
            print(f"Sample data:\n{data.head()}\n")

        else:
            print(f"File format of {file} is not supported.\n")

    except FileNotFoundError:
        print(f"File not found: {file}")
    except Exception as e:
        print(f"An error occurred while processing {file}: {e}")

print("Processing complete.")
