import sys
sys.path.append('/data/home/ifb5104/K_server_RL')
from KServerEnv import KServerEnv 
from Policies.DQN_10 import DQNAgent_10
# from Qtable import Qtable
from Policies.Qtable_MP import Qtable
from Policies.GCN_SL import GCN_SL
from Policies.GCN_RL import GCN_RL
import csv
import os 
from generate_requests import generate_requests
import torch
from multiprocessing import Pool, cpu_count
import psutil
import argparse
import time
import os



parser = argparse.ArgumentParser()
parser.add_argument("--use_all_cpus", action='store_true', help="Whether to use all free cpus")
parser.add_argument("--thread_pool", action='store_true', help="Whether to use ThreadPool instead of Pool")
parser.add_argument("--device", type=str, default="cpu", help="Which device to use")
parser.add_argument("--save", action='store_true', help="Whether to save the model")
parser.add_argument("--display_results", action='store_true', help="Display results in Neptune")
parser.add_argument("--gamma", type=float, default=0.99, help="Temporal Discount")
parser.add_argument("--print_results", action='store_true', help="Whether to print the experiments results during the training")
parser.add_argument("--uniform_random", action='store_true', help="If probabilities of arrival of requests are uniform")
parser.add_argument("--parallel", action='store_true', help="If to run the processes in parallel")
parser.add_argument("--var_distance", action='store_true', help="If to set a varying distance between nodes")
parser.add_argument("--tr_dist", action='store_true', help="If we train the distance between nodes")

# parser.add_argument("--grid", type = bool, default = False, help="If graph type is grid")

args = parser.parse_args()
# test_all = args.test_all
use_all_cpus = args.use_all_cpus

thread_pool = args.thread_pool
device = args.device
save = args.save
display_results = args.display_results
gamma = args.gamma
print_results  = args.print_results
uniform_random = False
request_same_node=True
arrival_rates=True
seq_req=True
var_distance = args.var_distance 
tr_dist = args.tr_dist 







# methods  = [GreedyPolicy, HarmonicPolicy, BalancePolicy]
methods = [GCN_RL]
# methods  = [WorkFunction]
# number_nodes = [9, 16, 25, 36, 49, 64, 81, 100]
number_nodes = [36, 64, 100]
# number_nodes = [24]
hidden_channels_list = [128]
graph_types = [ 'grid_dir_51', 'grid_dir_50','grid_dir_52', 'grid_dir_53', 'grid_dir_54']
# graph_types = ['grid_gre_50', 'grid_gre_51', 'grid_gre_52', 'grid_gre_53', 'grid_gre_54']
# graph_types = ['SF']
# graph_types = [ 'grid_gre_51', 'grid_gre_50','grid_gre_52', 'grid_gre_53', 'grid_gre_54', \
#      'tree_50', 'tree_51', 'tree_52', 'tree_53', 'tree_54']
#  'plane_50', 'plane_51', 'plane_52', 'plane_53', 'plane_54'       
seeds = [42]
     
    





args_list = []
for method in methods:
    if method in [DQNAgent_10]:
        for num_nodes in number_nodes:
            for graph_type in graph_types:
                for seed in seeds:
                    args_list.append((method, num_nodes, graph_type, seed))
    # elif method in [GCN_RL, GCN_SL]:
    elif method in [GCN_RL]:
        for num_nodes in number_nodes:
            for graph_type in graph_types:
                for hidden_channels in hidden_channels_list:
                    args_list.append((method, num_nodes, graph_type, hidden_channels))
    
    

    elif method == Qtable:
        for num_nodes in number_nodes[:2]:
            for graph_type in graph_types:
                    args_list.append((method, num_nodes, graph_type))
                    
    else:
        for num_nodes in number_nodes:
            for graph_type in graph_types:
                args_list.append((method, num_nodes, graph_type))





# print(args_list)

def run_experiment(hyperparams):

    start_time = time.time()
    num_nodes = hyperparams[1]
    Agent = hyperparams[0]
    
    graph_type = hyperparams[2]
    seed = 42
    hidden_channels = 128

    num_servers = round(num_nodes / 6)

    env = KServerEnv(num_nodes, num_servers, batch_size=1, graph_type=graph_type, device=device,\
            uniform_random = uniform_random, request_same_node=request_same_node, arrival_rates=arrival_rates, seq_req=seq_req, var_distance = var_distance)
    agent = Agent(env, hidden_channels = hidden_channels, shared_weights = False, gamma = gamma, est_pr_acc = True, dir_graph = True) 


    agent_name = str(Agent).split("'")[1].split(".")[-1]

    file_paths = [
    f'results/gen_testing/VD{var_distance}/{agent_name}_acc/results_{graph_type}_{agent_name}_{num_nodes}__gamma{gamma}.csv',
    f'results/gen_testing/VD{var_distance}/{agent_name}_acc/results_{graph_type}_{agent_name}_{num_nodes}_gamma{gamma}.csv']

    


    if any(os.path.exists(file_path) for file_path in file_paths):
        print(f'Skipping experiment for {hyperparams}, as one or more result files exist.') 
    else: 
        print(f'Experiment_{graph_type}_{agent_name}_{num_nodes}_seed{seed}_hidden_channels{hidden_channels} started')
        print(f'results/gen_testing/VD{var_distance}/{agent_name}/train_results/models/model_{graph_type}_{agent_name}_{num_nodes}_hidden_channels{hidden_channels}__gamma{gamma}_vd{var_distance}_td{tr_dist}.pth')
        if Agent in [GCN_RL, GCN_SL, DQNAgent_10]:
            try:
                agent.q_network.load_state_dict(torch.load(f'results/gen_testing/VD{var_distance}/{agent_name}/train_results/models/model_{graph_type}_{agent_name}_{num_nodes}_hidden_channels{hidden_channels}__gamma{gamma}_vd{var_distance}_td{tr_dist}.pth'))
            except: 
                agent.q_network.load_state_dict(torch.load(f'results/gen_testing/VD{var_distance}/{agent_name}/train_results/models/model_{graph_type}_{agent_name}_{num_nodes}_gamma{gamma}_vd{var_distance}.pth'))

        # agent.print_network_weights()
        num_sequences = 10
        requests, state = generate_requests(env, seed, 4000, num_sequences=num_sequences)
    
        estimates = []
        q1s =[]
        q3s = []
        raw_results = []
        for i in range(num_sequences):
            print('started')
            estimate, q1, q3, raw_result = agent.estimate_seq(state[i].unsqueeze(0), requests[i].unsqueeze(0))
            estimates.append(estimate)
            q1s.append(q1)
            q3s.append(q3)
            raw_results.append(raw_result)
            print(f'sequence{i} finished')
        if save:
            if not os.path.exists(f'results/gen_testing/VD{var_distance}/{agent_name}_acc'):  
                os.makedirs(f'results/gen_testing/VD{var_distance}/{agent_name}_acc')
            if not os.path.exists(f'results/gen_testing/VD{var_distance}/{agent_name}_acc/models'):
                os.makedirs(f'results/gen_testing/VD{var_distance}/{agent_name}_acc/models')  
            if not os.path.exists(f'results/gen_testing/VD{var_distance}/{agent_name}_acc/raw_results'):
                os.makedirs(f'results/gen_testing/VD{var_distance}/{agent_name}_acc/raw_results')      

            output_file_name = f'results/gen_testing/VD{var_distance}/{agent_name}_acc/results_{graph_type}_{agent_name}_{num_nodes}__gamma{gamma}.csv'
            with open(output_file_name, 'w', newline='') as f:
                    writer = csv.writer(f)
                    writer.writerow(['graph_type', 'agent', 'gamma','num_nodes', 'seed', 'hidden_channels', 'estimate', 'q1', 'q3'])
                    for i in range(num_sequences):    
                        writer.writerow([graph_type, agent_name, gamma, num_nodes, seed, hidden_channels, round(estimates[i].item(), 3), round(q1s[i].item(), 3), round(q3s[i].item(), 3)])  
                        # writer.writerow([graph_type, agent_name, gamma, num_nodes, seed, hidden_channels, round(estimates[i].item(), 3), '', ''])
            
            output_file_name_raw = f'results/gen_testing/VD{var_distance}/{agent_name}_acc/raw_results/results_{graph_type}_{agent_name}_acc_{num_nodes}__gamma{gamma}_raw.csv'
            
            with open(output_file_name_raw, 'w', newline='') as f:
                    writer = csv.writer(f)
                    for i in range(num_sequences):    
                        writer.writerow(raw_results[i].tolist()) 
        end_time = time.time()
        elapsed_time = end_time - start_time

        print(f'Experiment_{graph_type}_{agent_name}_{gamma}_{num_nodes}_seed{seed}_hidden_channels{hidden_channels} took {round(elapsed_time, 3)} seconds to finish')

        

print("Starting the experiments")
print("Number of experiments:", len(args_list))
print("Device:", device)
print("Save:", save)
print("Uniform Random:", uniform_random)
print("Display Results:", display_results)

if __name__ == "__main__":

    max_cpu_usage_percent = 50
    num_processes = min(cpu_count(), len(methods)*len(number_nodes)*len(graph_types))
    
    cpu_usage_percent = psutil.cpu_percent(interval=1)
    free_cpus = cpu_count() - int(cpu_count() * (cpu_usage_percent / 100))
    
    print("Number of free CPUs:", free_cpus)
    print("Using all free CPUs:", bool(use_all_cpus))

    start_time_total = time.time()

    if args.parallel:
        with Pool(processes=20) as pool:
            pool.map(run_experiment, args_list)

    else:
        for hyperparams in args_list:
            run_experiment(hyperparams)
    end_time_total = time.time()
    elapsed_time_total = end_time_total - start_time_total
    print(f'Total time elapsed in seconds:', round(elapsed_time_total, 3))

    

    # while True:
    #     cpu_usage_percent = psutil.cpu_percent(interval=1)
    #     free_cpus = cpu_count() - int(cpu_count() * (cpu_usage_percent / 100))
    #     if free_cpus >= num_processes:
    #         break
    #     print(f'CPU usage is {cpu_usage_percent}%, waiting for available CPUs...')

    # with Pool(processes=20) as pool:
    #     pool.map(run_experiment, args_list2)

    # with Pool(processes=(16)) as pool:
    #    pool.map(run_experiment, args_list)

    
 






    