
# K-Server RL Project

This project implements reinforcement learning policies for the K-server problem on graphs. It provides a flexible environment for simulating different K-server scenarios and evaluating the performance of various algorithms.

## Table of Contents
- [Project Overview](#project-overview)
- [Installation](#installation)
- [Usage](#usage)
- [Project Structure](#project-structure)
- [Experiments](#experiments)
- [Results](#results)
- [Contributing](#contributing)
- [License](#license)

## Project Overview
The K-server problem is a well-known problem in online algorithms and competitive analysis. This project provides an environment to develop, train, and evaluate reinforcement learning policies for the K-server problem using Python. The environment supports various configurations and offers a way to test the scalability and effectiveness of decision-making algorithms in time-sensitive contexts.

## Installation
To set up the project locally, follow these steps:

1. Clone this repository:
    ```bash
    git clone https://github.com/your-username/K_server_RL.git
    ```
2. Navigate to the project directory:
    ```bash
    cd K_server_RL
    ```
3. Install the required dependencies:
    ```bash
    pip install -r requirements.txt
    ```

## Usage
### Running Experiments
To run experiments, use the `experiments_single_experiment_testing.py` script located in the `experiments` directory. Customize the parameters in the script as needed.

```bash
cd experiments
python experiments_single_experiment_testing.py
```

## Project Structure
- **KServerEnv.py**: Main environment implementation for the K-server problem.
- **generate_requests.py**: Script to generate requests for the K-server environment.
- **experiments/**: Contains scripts for running various experiments, including `experiments_single_experiment_testing.py`.
- **Policies/**: Implementations of different policies for the K-server problem.
- **results/**: Stores results of experiments and simulations.
- **data/**: Contains datasets or input data for the environment.
- **.neptune/**: Configuration related to experiment tracking with Neptune (optional).
- **.gitignore**: Specifies files and directories to be ignored in the Git repository.

## Experiments
Run the main experiment script, `experiments_single_experiment_testing.py`, found in the `experiments` directory. This script will perform the necessary simulations and evaluations, saving the results in the `results` directory.

```bash
cd experiments
python experiments_single_experiment_testing.py
```

## Results
Results from the experiments can be found in the `results` directory. These results include metrics, plots, and logs that help analyze the performance of different policies in the K-server environment.

## Contributing
Contributions are welcome! If you have suggestions for improving this project, feel free to create an issue or submit a pull request.

## License
This project is licensed under the MIT License. See the `LICENSE` file for more details.
