import sys
sys.path.append('/data/home/ifb5104/K_server_RL')
from KServerEnv import KServerEnv 
from Policies.DQN_10 import DQNAgent_10
from Policies.DQN_Lins import DQNAgent_Lins
from Policies.Qtable_MP import Qtable
from Policies.Qtable_WQL import Qtable_WQL 
from Policies.Random_Greedy import RandomPolicy, GreedyPolicy
from Policies.GCN_SL import GCN_SL
from Policies.GCN_RL import GCN_RL
import csv
import os 

from Policies.Balance import BalancePolicy
from Policies.Harmonic import HarmonicPolicy

from generate_requests import generate_requests
import torch
from multiprocessing import Pool, cpu_count
import psutil
import argparse
import time
from generate_requests import generate_requests



parser = argparse.ArgumentParser()
parser.add_argument("--use_all_cpus", action='store_true', help="Whether to use all free cpus")
parser.add_argument("--thread_pool", action='store_true', help="Whether to use ThreadPool instead of Pool")
parser.add_argument("--device", type=str, default="cpu", help="Which device to use")
parser.add_argument("--save", action='store_true', help="Whether to save the model")
parser.add_argument("--display_results", action='store_true', help="Display results in Neptune")
parser.add_argument("--gamma", type=float, default=0.99, help="Temporal Discount")
parser.add_argument("--print", action='store_true', help="Whether to print the experiments results during the training")
parser.add_argument("--uniform_random", action='store_true', help="If probabilities of arrival of requests are uniform")
parser.add_argument("--parallel", action='store_true', help="If to run the processes in parallel")
parser.add_argument("--var_distance", action='store_true', help="If to set a varying distance between nodes")
parser.add_argument("--tr_dist", action='store_true', help="If we train the distance between nodes")
parser.add_argument("--print_seq", action='store_true', help="Print where it is going to be tested")
parser.add_argument("--dir_graph", action='store_true', help="If it is a directed graph architecture")
parser.add_argument("--bs", type=int, default=128, help="Batch Size")
args = parser.parse_args()


use_all_cpus = args.use_all_cpus
thread_pool = args.thread_pool
device = args.device
save = args.save
display_results = args.display_results
gamma = args.gamma
print_results  = args.print
uniform_random = False
request_same_node=True
arrival_rates=True
seq_req=True
burn_in = False
burn_in_period = 100
var_distance = args.var_distance 
tr_dist = args.tr_dist 
batch_size = args.bs




# methods  = [GCN_RL, GreedyPolicy]
# methods = [WorkFunction]
# methods = [DQNAgent_Lins] 
methods = [ GCN_RL, GreedyPolicy] 
# methods = [GCN_RL]
# methods = [Qtable_WQL]
# methods  = [WorkFunction]
# number_nodes = [36, 64,100]
# number_nodes = [16, 49, 100]
# number_nodes = [9, 25, 36]
# number_nodes = [49, 81]
number_nodes = [25, 49, 64, 81]
# number_nodes = [9, 25, 36, 64]
# number_nodes = [9, 16, 25, 36, 49, 64, 81, 100]
# number_nodes = [74]
hidden_channels_list = [128]
# graph_types = [ 'bn_grid_gre_51', 'bn_grid_gre_50','bn_grid_gre_52', \
#     'bn_grid_gre_53', 'bn_grid_gre_54', 'psn_grid_gre_51', 'psn_grid_gre_50',\
#         'psn_grid_gre_52', 'psn_grid_gre_53', 'psn_grid_gre_54', \
#             'lgnm_grid_gre_51', 'lgnm_grid_gre_50','lgnm_grid_gre_52', \
#                 'lgnm_grid_gre_53', 'lgnm_grid_gre_54'] 
# graph_types = [ 'bn_grid_gre_51', 'bn_grid_gre_50', 'psn_grid_gre_51', 'psn_grid_gre_50',\
#                 'lgnm_grid_gre_53', 'lgnm_grid_gre_54'] 
# graph_types = ['EM']
# graph_types = ['grid_gre_50']
# graph_types = ['grid_gre_50', 'grid_gre_51', 'grid_gre_52', 'grid_gre_53', 'grid_gre_54']
# graph_types = [ 'grid_dir_51', 'grid_dir_50','grid_dir_52', 'grid_dir_53', 'grid_dir_54']
# graph_types = ['tree_50', 'tree_51', 'tree_52', 'tree_53', 'tree_54']
# graph_types = ['grid_dir_50', 'grid_dir_51', 'grid_dir_52', 'grid_dir_53', 'grid_dir_54']
graph_types = ['grid_dir_60', 'grid_dir_61', 'grid_dir_62', 'grid_dir_63', 'grid_dir_64']
# graph_types = ['plane_50', 'plane_51', 'plane_52', 'plane_53', 'plane_54']
# graph_types = [ 'grid_gre_51', 'grid_gre_50','grid_gre_52', 'grid_gre_53', 'grid_gre_54', \
#      'tree_50', 'tree_51', 'tree_52', 'tree_53', 'tree_54']
#          'plane_50', 'plane_51', 'plane_52', 'plane_53', 'plane_54']
#  'plane_50', 'plane_51', 'plane_52', 'plane_53', 'plane_54'       
seeds = [42]
     
    



args_list = []
for method in methods:
    if method in [DQNAgent_10, DQNAgent_Lins]:
        for num_nodes in number_nodes:
            for graph_type in graph_types:
                for seed in seeds:
                    args_list.append((method, num_nodes, graph_type, seed))
    # elif method in [GCN_RL, GCN_SL]:
    elif method in [GCN_RL]:
        for num_nodes in number_nodes:
            for graph_type in graph_types:
                for hidden_channels in hidden_channels_list:
                    args_list.append((method, num_nodes, graph_type, hidden_channels))
                    
    elif method == Qtable:
        for num_nodes in number_nodes[:2]:
            for graph_type in graph_types:
                    args_list.append((method, num_nodes, graph_type))

    else:
        for num_nodes in number_nodes:
            for graph_type in graph_types:
                args_list.append((method, num_nodes, graph_type))





print('start')

def run_experiment(hyperparams):

    start_time = time.time()
    num_nodes = hyperparams[1]
    Agent = hyperparams[0]
    graph_type = hyperparams[2]
    seed = 42
    hidden_channels = 128
    num_sequences = 10
    num_servers = 4
    agent_name = str(Agent).split("'")[1].split(".")[-1]

    file_paths = [
    f'results/gen_testing/VD{var_distance}/{agent_name}/results_{graph_type}_{agent_name}_{num_nodes}_{num_servers}_hidden_channels{hidden_channels}__gamma{gamma}.csv',
    f'results/gen_testing/VD{var_distance}/{agent_name}/results_{graph_type}_{agent_name}_{num_nodes}_{num_servers}_hidden_channels{hidden_channels}_gamma{gamma}.csv',
    f'results/gen_testing/VD{var_distance}/{agent_name}/results_{graph_type}_{agent_name}_{num_nodes}_{num_servers}__gamma{gamma}.csv',
    f'results/gen_testing/VD{var_distance}/{agent_name}/results_{graph_type}_{agent_name}_{num_nodes}_{num_servers}_gamma{gamma}.csv']

    if any(os.path.exists(file_path) for file_path in file_paths):
        print(f'Skipping experiment for {hyperparams}, as one or more result files exist.') 
    else: 
        print(f'Experiment_{graph_type}_{agent_name}_{num_nodes}_{num_servers}_seed{seed}_hidden_channels{hidden_channels} started')
        # num_servers = round(num_nodes / 6)
        

        if Agent in [DQNAgent_10, DQNAgent_Lins]:
            env = KServerEnv(num_nodes, num_servers, batch_size=num_sequences, graph_type=graph_type, device=device,\
                uniform_random = uniform_random, request_same_node=request_same_node, arrival_rates=arrival_rates, seq_req=seq_req, var_distance= var_distance)
            agent = Agent(env, seed = seed)

        elif Agent in [GCN_RL, GCN_SL]:
            env = KServerEnv(num_nodes, num_servers, batch_size=1, graph_type=graph_type, device=device,\
                uniform_random = uniform_random, request_same_node=request_same_node, arrival_rates=arrival_rates, seq_req=seq_req, var_distance= var_distance)
            agent = Agent(env, hidden_channels = hidden_channels, shared_weights = False, gamma = gamma, dir_graph = args.dir_graph, num_layers = 12, use_batch_norm = True)  

        elif Agent == BalancePolicy:
            env = KServerEnv(num_nodes, num_servers, batch_size=1, graph_type=graph_type, device=device,\
                uniform_random = uniform_random, request_same_node=request_same_node, arrival_rates=arrival_rates, seq_req=seq_req, balanced_algorithm=True, var_distance= var_distance)
            agent = Agent(env)

        else: 
            env = KServerEnv(num_nodes, num_servers, batch_size=1, graph_type=graph_type, device=device,\
                uniform_random = uniform_random, request_same_node=request_same_node, arrival_rates=arrival_rates, seq_req=seq_req, var_distance=var_distance)
            agent = Agent(env)

        
        if Agent not in [GreedyPolicy, BalancePolicy, HarmonicPolicy, Qtable_WQL]:
        
            print(f"Total Parameters: {agent.total_params()}")
        

        


        
        # print(f'Experiment_{graph_type}_{agent_name}_{num_nodes}_{num_servers}_seed{seed}_hidden_channels{hidden_channels} started')
        if Agent in [GCN_RL, GCN_SL, DQNAgent_10, DQNAgent_Lins]:
            # print(f'results/gen_testing/{agent_name}/train_results/models/model_{graph_type}_{agent_name}_{num_nodes}_{num_servers}_hidden_channels{hidden_channels}__gamma{gamma}.pth')
            # agent.q_network.load_state_dict(torch.load(f'results/gen_testing/{agent_name}/train_results/models/model_{graph_type}_{agent_name}_{num_nodes}_{num_servers}_gamma{gamma}_vd{var_distance}.pth'))
            if Agent in [GCN_RL, GCN_SL]:
                # agent.q_network.load_state_dict(torch.load(f'results/gen_testing/{agent_name}/train_results/models/model_{graph_type}_{agent_name}_{num_nodes}_{num_servers}_hidden_channels{hidden_channels}__gamma{gamma}.pth')) # 
                
                agent.q_network.load_state_dict(torch.load(f'results/gen_testing/VD{agent.var_distance}/{agent.class_name}/train_results/models/model_{agent.env.graph_type}_{agent.class_name}_{agent.env.num_nodes}_{agent.env.num_servers}_hidden_channels{agent.hidden_channels}__gamma{agent.gamma}_vd{agent.var_distance}_td{agent.tr_dist}_ta{agent.tr_att}_seed{agent.seed}_DG{agent.dir_graph}_bs{batch_size}_lr{agent.lr}_nl{agent.num_layers}.pth'))
            else: 
                agent.q_network.load_state_dict(torch.load(f'results/gen_testing/VD{agent.var_distance}/{agent.class_name}/train_results/models/model_{agent.env.graph_type}_{agent.class_name}_{agent.env.num_nodes}_{agent.env.num_servers}_gamma{agent.gamma}_vd{agent.var_distance}.pth'))

        if Agent == Qtable:
            agent.q_table = torch.load(f'results/gen_testing/VD{var_distance}/{agent_name}/train_results/models/model_{graph_type}_{agent_name}_{num_nodes}_{num_servers}_gamma{gamma}.pth')

        
        requests, state = generate_requests(env, seed, 4000, num_sequences=num_sequences)


        if args.print_seq: 
            # Function to find the most frequent element in a 1D tensor
            def most_frequent_element(tensor_row):
                return torch.mode(tensor_row).values.item()

            # Apply the function to each row of the 2D tensor
            most_frequent_elements = [most_frequent_element(row) for row in requests]

            print("The most frequent elements for each row are:", most_frequent_elements)
            index_of_largest_value = env.probabilities.index(max(env.probabilities))
            print("The index of the largest value is:", index_of_largest_value)
            # print(env.probabilities)
            print(state)

        
        if Agent in [GCN_SL, DQNAgent_10, DQNAgent_Lins]:
            estimates = agent.estimate_seq(state, requests)[3]  
            estimate_sums = torch.sum(estimates, dim = 1)
        else:
            start_time = time.time()        
            estimates = []
            q1s =[]
            q3s = []
            raw_results = [] 
            for i in range(num_sequences):
                print(f'sequence{i} started')
                estimate, q1, q3, raw_result = agent.estimate_seq(state[i].unsqueeze(0), requests[i].unsqueeze(0))
                estimates.append(estimate)
                q1s.append(q1)
                q3s.append(q3)
                raw_results.append(raw_result)
                # print(f'sequence{i} finished')
            elapsed_time = time.time() - start_time
            print('inference time:', elapsed_time)

        
                    

            # estimates, q1s, q3s, raw_results = agent.estimate(40, episode = True)
                
            
            
            
            # Include the seed in the output CSV file name if it's a DQNAgent or DQNAgent_10

            

        if save:
            if not os.path.exists(f'results/gen_testing/VD{var_distance}/{agent_name}'):  
                os.makedirs(f'results/gen_testing/VD{var_distance}/{agent_name}')
            if not os.path.exists(f'results/gen_testing/VD{var_distance}/{agent_name}/models'):
                os.makedirs(f'results/gen_testing/VD{var_distance}/{agent_name}/models')  
            if not os.path.exists(f'results/gen_testing/VD{var_distance}/{agent_name}/raw_results'):
                os.makedirs(f'results/gen_testing/VD{var_distance}/{agent_name}/raw_results')  
            
            output_file_name = f'results/gen_testing/VD{var_distance}/{agent_name}/results_{hyperparams[2]}_{agent_name}_{num_nodes}_{num_servers}_gamma{gamma}.csv'
            output_file_name_raw = f'results/gen_testing/VD{var_distance}/{agent_name}/raw_results/results_{hyperparams[2]}_{agent_name}_{num_nodes}_{num_servers}_gamma{gamma}_raw.csv'
            
            if Agent in [GCN_SL, DQNAgent_10, DQNAgent_Lins]:
                
                with open(output_file_name, 'w', newline='') as f:
                        writer = csv.writer(f)
                        writer.writerow(['graph_type', 'agent', 'gamma','num_nodes', 'seed', 'hidden_channels', 'estimate'])
                        for i in range(num_sequences):    
                            writer.writerow([graph_type, agent_name, gamma, num_nodes, seed, hidden_channels, round(estimate_sums[i].item(), 3)])  
                        
                with open(output_file_name_raw, 'w', newline='') as f:
                        writer = csv.writer(f)
                        # writer.writerow([raw_result])
                        for i in range(num_sequences):    
                            row_as_list = estimates[i].tolist()
                            row_as_string = str(row_as_list)
                            
                            # Write the string representation of the row to the file
                            writer.writerow([row_as_string])

            else:
                
                with open(output_file_name, 'w', newline='') as f:
                        writer = csv.writer(f)
                        writer.writerow(['graph_type', 'agent', 'gamma','num_nodes', 'seed', 'hidden_channels', 'estimate', 'q1', 'q3'])
                        for i in range(num_sequences):    
                            writer.writerow([graph_type, agent_name, gamma, num_nodes, seed, hidden_channels, round(estimates[i].item(), 3), round(q1s[i].item(), 3), round(q3s[i].item(), 3)])  
                            # writer.writerow([graph_type, agent_name, gamma, num_nodes, seed, hidden_channels, round(estimates[i].item(), 3), '', ''])
     
                with open(output_file_name_raw, 'w', newline='') as f:
                        writer = csv.writer(f)
                        for i in range(num_sequences):    
                            writer.writerow(raw_results[i].tolist()) 

        end_time = time.time()
        elapsed_time = end_time - start_time

        print(f'Experiment_{graph_type}_{agent_name}_{gamma}_{num_nodes}_{num_servers}_seed{seed}_hidden_channels{hidden_channels} took {round(elapsed_time, 3)} seconds to finish')

            

print("Starting the experiments")
print("Number of experiments:", len(args_list))
print("Device:", device)
print("Save:", save)
print("Uniform Random:", uniform_random)
print("Display Results:", display_results)

if __name__ == "__main__":

    max_cpu_usage_percent = 50
    num_processes = min(cpu_count(), len(methods)*len(number_nodes)*len(graph_types))
    
    cpu_usage_percent = psutil.cpu_percent(interval=1)
    free_cpus = cpu_count() - int(cpu_count() * (cpu_usage_percent / 100))
    
    print("Number of free CPUs:", free_cpus)
    print("Using all free CPUs:", bool(use_all_cpus))

    start_time_total = time.time()

    if args.parallel:
        with Pool(processes=40) as pool:
            pool.map(run_experiment, args_list)

    else:
        for hyperparams in args_list:
            run_experiment(hyperparams)

    end_time_total = time.time()
    elapsed_time_total = end_time_total - start_time_total

    print(f'Total time elapsed in seconds:', round(elapsed_time_total, 3))

    

    # while True:
    #     cpu_usage_percent = psutil.cpu_percent(interval=1)
    #     free_cpus = cpu_count() - int(cpu_count() * (cpu_usage_percent / 100))
    #     if free_cpus >= num_processes:
    #         break
    #     print(f'CPU usage is {cpu_usage_percent}%, waiting for available CPUs...')

    # with Pool(processes=20) as pool:
    #     pool.map(run_experiment, args_list2)

    # with Pool(processes=(16)) as pool:
    #    pool.map(run_experiment, args_list)

    
 






    