import sys
from itertools import product
sys.path.append('/data/home/ifb5104/K_server_RL')
from Policies.GCN_RL_GEN_ALL import GCN_RL_GEN_ALL

# Define hyperparameter ranges
batch_sizes = [2, 8, 16, 64, 128, 256]
hidden_channels_list = [64, 128, 256]
gammas = [0.9, 0.95, 0.99]
num_layers_list = [2, 4, 8, 12, 16]
learning_rates = [0.001, 0.0001]

# Generate combinations of hyperparameters
hyperparameter_combinations = list(product(batch_sizes, hidden_channels_list, gammas, num_layers_list, learning_rates))

# Iterate over all combinations and run experiments
for batch_size, hidden_channels, gamma, num_layers, lr in hyperparameter_combinations:
    print(f"Running experiment with batch_size={batch_size}, hidden_channels={hidden_channels}, gamma={gamma}, num_layers={num_layers}, lr={lr}")

    # Initialize agent with the current combination of hyperparameters
    agent = GCN_RL_GEN_ALL(
        hidden_channels=hidden_channels, 
        general_model_gt='grid_dir', 
        batch_size=batch_size, 
        uniform_random=False,  
        constant_probability=False, 
        arrival_rates=True, 
        request_same_node=True, 
        gamma=gamma,
        var_pr_ep=True, 
        var_pr_ep_steps=30,  
        use_batch_norm=True, 
        var_distance=False, 
        dir_graph=True, 
        device='cuda', 
        num_layers=num_layers, 
        lr=lr
    )

    # Optimize the agent
    # agent.optimize(200, print_results = True)
    agent.optimize(200, print_results=True, save_model=True, save_results=True, display_results=True)
