#!/bin/bash


mujoco_envs=(
    "hopper-random-v2"
    "halfcheetah-random-v2"
    "walker2d-random-v2"
    "hopper-medium-v2"
    "walker2d-medium-v2"
    "halfcheetah-medium-v2"
    "halfcheetah-medium-replay-v2"
    "walker2d-medium-replay-v2"
    "hopper-medium-replay-v2"
)


antmaze_envs=(
    "antmaze-large-diverse-v0"
    "antmaze-large-play-v0"
    "antmaze-umaze-diverse-v0"
    "antmaze-umaze-v0"
    "antmaze-medium-play-v0"
    "antmaze-medium-diverse-v0"
)


for seed in 42
do
    for env_name in ${mujoco_envs[*]}
    do
        python train_offline_agent.py \
        --config=configs/mujoco.py \
        --config.env_name=$env_name \
        --config.seed=$seed
    done
done


for seed in 42
do
    for env_name in ${antmaze_envs[*]}
    do
        python train_offline_agent.py \
        --config=configs/antmaze.py \
        --config.env_name=$env_name \
        --config.seed=$seed
    done
done
