"""
Run Multi-Dataset Ablation Study
===============================

This script runs the final ablation study on multiple datasets
to show good performance across different datasets.
"""

import torch
import torch.nn as nn
import torch.nn.functional as F
import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
import seaborn as sns
import os
from torch_geometric.nn import GCNConv, GATConv, GINConv, SAGEConv
from torch_geometric.data import Data
from torch_geometric.datasets import Planetoid
from torch_geometric.transforms import NormalizeFeatures
import time
import warnings
warnings.filterwarnings('ignore')

# Import the final ablation study classes
from final_ablation_study import FinalAblationGraGRCore, FinalAblationStudyRunner

def run_multi_dataset_ablation():
    """Run ablation study on multiple datasets."""
    device = 'cuda' if torch.cuda.is_available() else 'cpu'
    print(f"🖥️  Using device: {device}")
    
    runner = FinalAblationStudyRunner(device=device)
    
    # Run ablation study on multiple datasets
    datasets = ['cora', 'citeseer', 'pubmed']  # Multiple datasets for comparison
    
    results = runner.run_final_ablation_study(datasets=datasets, epochs=25)
    
    print("\n🎉 Multi-Dataset Ablation Study Completed!")
    print(f"📊 Total experiments: {len(results)}")
    print(f"📁 Results saved in: GraGR_Research_Results/final_ablation_study/")
    
    return results

if __name__ == "__main__":
    results = run_multi_dataset_ablation()
