Setup:
	- Install Python 3.8
	- Run `pip install -r requirements.txt` to install dependencies
	- Run `pip install -e transformers` in the root directory.
	- Download TACRED following https://nlp.stanford.edu/projects/tacred/#access.

Folder Structure:
	- `np/`: Novelty Prompting and other generation baselines
		- `generate_fewshot.py` and `generate_zeroshot.py` are used to generate data for baselines.
		- `generate_np.py` is used to perform novelty prompting.
		- `filter_moby.py` is used to filter generations out post-hoc from labels that are synonyms of closed-set labels.
	- `ccl/`: Training with CCL and OE losses
		- `get_wikitext.py` and `make_data.py` are used for retrieving/processing raw datasets (TREC-10, Emotion, AGNews, TACRED, Wikitext-103). You will need to download TACRED separately following https://nlp.stanford.edu/projects/tacred/#access. See Makefile for how to call `make_data.py`.
		- `train_classifier.py` should be used to train a model with CCL/OE given a novel set (or if no novel set, Vanilla).
		- `score.py` scores trained checkpoints for AUAC, AUROC, and ID Acc.
	- `generations/`: We include some generations from each of Novelty Prompting, Zero-shot, and Few-shot generation for each dataset split. Due to size limitations we include only 1000 of each.
