import cramming
import hydra
import torch

def main_training_process(cfg, setup):
    """This function controls the central training loop."""
    model = cramming.construct_model(cfg.arch, 32768)

    # print parameter nums of model in descending order
    for name, param in model.named_parameters():
        print(name, param.numel())
        

@hydra.main(config_path="cramming/config", config_name="cfg_pretrain", version_base="1.1")
def launch(cfg):
    cramming.utils.main_launcher(cfg, main_training_process, job_name="pretraining")


if __name__ == "__main__":
    launch()