DATASET="imagenet-1k"
BATCH_SIZE=32
SEED=0

SAMPLE_RATIO=0.33

OUTPUT_DIR="${DATASET}_base_seed${SEED}_ub${SAMPLE_RATIO}"

CUDA_VISIBLE_DEVICES=$1 python finetune_imagenet_ub.py \
    --model_name_or_path "./vit-base-patch16-224-in21k" \
    --dataset_name "/mnt/data/imagenet-1k" \
    --output_dir ${OUTPUT_DIR} \
    --learning_rate 2e-5 \
    --num_train_epochs 5 \
    --batch_size ${BATCH_SIZE} \
    --eval_batch_size ${BATCH_SIZE} \
    --eval_freq 20000 \
    --seed ${SEED} \
    --sample_ratio ${SAMPLE_RATIO} \
    --wandb