DATASET="imagenet-1k"
BATCH_SIZE=128
SEED=0

CAL_VAR_FREQ=10
EVAL_FREQ=20

CAL_VAR_M=2
S=1
ACT_VAR_TOLERANCE=0.05
WEIGHT_VAR_TOLERANCE=0.05
S_UPDATE_STEP=0.005
WEIGHT_RATIO_MULTIPLIER=0.95

OUTPUT_DIR="pretrain_${DATASET}_large_epoch10_seed${SEED}_freq${CAL_VAR_FREQ}_m${CAL_VAR_M}_s${S}_avt${ACT_VAR_TOLERANCE}_wvt${WEIGHT_VAR_TOLERANCE}_sus${S_UPDATE_STEP}_wrm${WEIGHT_RATIO_MULTIPLIER}"

CUDA_VISIBLE_DEVICES=$1 python run_pretrain.py \
    --dataset_name "/mnt/data/imagenet-1k" \
    --output_dir ${OUTPUT_DIR} \
    --learning_rate 2e-5 \
    --num_train_epochs 10 \
    --batch_size ${BATCH_SIZE} \
    --eval_batch_size ${BATCH_SIZE} \
    --seed ${SEED} \
    --cal_var_freq ${CAL_VAR_FREQ} \
    --eval_freq ${EVAL_FREQ} \
    --cal_var_m ${CAL_VAR_M} \
    --s ${S} \
    --act_var_tolerance ${ACT_VAR_TOLERANCE} \
    --weight_var_tolerance ${WEIGHT_VAR_TOLERANCE} \
    --s_update_step ${S_UPDATE_STEP} \
    --weight_ratio_multiplier ${WEIGHT_RATIO_MULTIPLIER} \
    # --wandb