#!/bin/bash

PYSCRIPT="scripts.benchmarks.benchmark"
ROOTDIR="results/benchmark"
DEVICE="cuda"

BENCHMARK_FLAGS="--backprop --num-iterations 50 --burnin-iterations 10 --device $DEVICE"

SEEDS=(41541 13124 945345 214932 239145)
NUNITS=(8 16 32 64 128 256 512)
NUNITSTUCKER=(8 10 12 14 16)

. ../.venv/bin/activate

# NUNITS
DIR="${ROOTDIR}/nunits"
for SEED in "${SEEDS[@]}"; do
    for NUNIT in "${NUNITS[@]}"; do
        # SOS + CP + Adam
        echo "[1/6] nunit $NUNIT seed $SEED"
        python -m "$PYSCRIPT" $BENCHMARK_FLAGS --seed $SEED --path $DIR \
            --num-units $NUNIT --input-shape 1 32 32 --batch-size 256 \
            --model SOS --optimizer Adam

        # SOS + CP + SGD
        echo "[2/6] nunit $NUNIT seed $SEED"
        python -m "$PYSCRIPT" $BENCHMARK_FLAGS --seed $SEED --path $DIR \
            --num-units $NUNIT --input-shape 1 32 32 --batch-size 256 \
            --model SOS --optimizer SGD

        # OSOS + CP + LandingSGD
        echo "[3/6] nunit $NUNIT seed $SEED"
        python -m "$PYSCRIPT" $BENCHMARK_FLAGS --seed $SEED --path $DIR \
            --num-units $NUNIT --input-shape 1 32 32 --batch-size 256 \
            --model OSOS --manifold-backend geoopt --optimizer LandingSGD
    done
    for NUNIT in "${NUNITSTUCKER[@]}"; do
        # SOS + Tucker + Adam
        echo "[4/6] nunit $NUNIT seed $SEED"
        python -m "$PYSCRIPT" $BENCHMARK_FLAGS --seed $SEED --path $DIR \
            --num-units $NUNIT --input-shape 1 32 32 --batch-size 256 \
            --model SOS --optimizer Adam --use-tucker

        # SOS + Tucker + SGD
        echo "[5/6] nunit $NUNIT seed $SEED"
        python -m "$PYSCRIPT" $BENCHMARK_FLAGS --seed $SEED --path $DIR \
            --num-units $NUNIT --input-shape 1 32 32 --batch-size 256 \
            --model SOS --optimizer SGD --use-tucker

        # OSOS + Tucker + LandingSGD
        echo "[6/6] nunit $NUNIT seed $SEED"
        python -m "$PYSCRIPT" $BENCHMARK_FLAGS --seed $SEED --path $DIR \
            --num-units $NUNIT --input-shape 1 32 32 --batch-size 256 \
            --model OSOS --manifold-backend geoopt --optimizer LandingSGD \
            --use-tucker
    done
done
