layer = [4, 12, 16, 24, 30, 42, 48, 60, 66, 80];
layer_NO = [3,5,7,9,12,15,18,21,24,28];
epoch = [1,31,56];
path = './translation_results/diagHessian_adaptGrad_200/';
ratios = fopen('./translation_results/R_med_OPT.txt','w');
k=1;
for l = 1:length(layer)
disp(' ');
display(['Layer' num2str(layer(l))]);
fprintf(ratios,'%d\t',layer_NO(l));
for i = 1:length(epoch)
    display(['Epoch=' num2str(epoch(i))]);
    data_sgd = readmatrix([path 'layer' num2str(layer(l)) '_epoch' num2str(epoch(i)) '_SGD_diag.txt']);
    data_ada = readmatrix([path 'layer' num2str(layer(l)) '_epoch' num2str(epoch(i)) '_Adam_diag.txt']);
    Hessian_sgd = data_sgd(:,1);
    grad_sgd = data_sgd(:,2);
    maxk_sgd = maxk(abs(Hessian_sgd),k);
    ratio_sgd_median = maxk_sgd(end)/median(abs(Hessian_sgd));
    display(['R_med^SGDM=' num2str(ratio_sgd_median)]);
    fprintf(ratios,'%6.2f\t',ratio_sgd_median);

    Hessian_ada = data_ada(:,1);
    grad_ada = data_ada(:,2);

    maxk_ada = maxk(abs(Hessian_ada),k);
    ratio_ada_median = maxk_ada(end)/median(abs(Hessian_ada));
    display(['R_med^Adam' num2str(ratio_ada_median)]);
    fprintf(ratios,'%6.2f\t',ratio_ada_median);
    if i > 1
    fprintf(ratios,'%6.2f\t',ratio_sgd_median/ratio_ada_median);
    end
end
fprintf(ratios,'\n');
end
fclose(ratios);