# Enhanced Model-agnostic Training of Deep Tabular Generation Models


This is the official implementation for the paper [Enhanced Model-agnostic Training of Deep Tabular Generation Models]

--------------------

## How to run the code

### Dependencies

Run the following to install a subset of necessary python packages for our code
```sh
conda env create -f requirements.yaml
```

### Usage

Train and evaluate our models through `main.py`.

```sh
main.py:
  --config: Training configuration.
    (default: 'None')
  --mode: <fine_tune>: Running mode: fine_tune
  --workdir: Working directory
```

* `config` is the path to the config file. Our prescribed config files are provided in `configs/`. They are formatted according to [`ml_collections`](https://github.com/google/ml_collections) and should be quite self-explanatory.

  **Naming conventions of config files**: the path of a config file is a combination of the following dimensions:
  * dataset: One of `Heart Disease`

*  `workdir` is the path that stores all artifacts of one experiment, like checkpoints, samples, and evaluation results.

You can run the source code by excuting the following command:
```
python main.py --config configs/heart_disease.py --mode train --workdir test
```
--------------------
