from pylab import *
import dill, sys
import numpy as np
from kernelhawkes import HawkesProcess


# 3D Mutually-Exciting Scenario ######################
######################################################

trig_ker= [[0,0,0],[0,0,0],[0,0,0]]
trig_ker[0][0] = lambda x: 0.5*exp(-x)
trig_ker[1][1] = lambda x: 0.3*exp(-0.5*x)
trig_ker[2][2] = lambda x: 0.5*exp(-x)
trig_ker[0][1] = lambda x: 0.5*exp(-10*(x-1)**2)
trig_ker[0][2] = lambda x: 0.5*exp(-20*(x-3)**2)
trig_ker[1][0] = lambda x: 0.5*2**(-5*x)
trig_ker[1][2] = lambda x: 0.5*exp(-20*(x-2)**2)
trig_ker[2][0] = lambda x: 0.2*exp(-3*(x-2)**2)
trig_ker[2][1] = lambda x: 0.5*(1+cos(pi*x)) * exp(-x)/2

mu = [0.01,0.01,0.01]
hp = HawkesProcess(mu=mu, kernel=trig_ker)
np.random.seed(0)

n_trial = 10
T = [2000, 3000, 5000, 7000]

hp.simulate(horizon=1000)

data = []
for n in range(n_trial):
    data.append(hp.simulate(horizon=T[-1]))

for t in T:
    spk = []
    for x in data:
        zz = []
        for xx in x:
            if xx[0] <= t:
                zz.append(xx)
        spk.append(zz)
    dill.dump({'spk':spk,'ker':trig_ker,'T':t,'mu':mu},
              open('data_synthetic/3D_EX_T'+str(t)+'.dill','wb'))
    print('T:',t)
    print(mean([len(x) for x in spk]))

# 3D Refractory Scenario #############################
######################################################

trig_ker= [[0,0,0],[0,0,0],[0,0,0]]
trig_ker[0][0] = lambda x: (8*x**2-1)*(x <= 0.5) + exp(-2.5*(x-0.5))*(x > 0.5)
trig_ker[1][1] = lambda x: (8*x**2-1)*(x <= 0.5) + exp(-(x-0.5))*(x > 0.5)
trig_ker[2][2] = lambda x: (8*x**2-1)*(x <= 0.5) + exp(-(x-0.5))*(x > 0.5)
trig_ker[0][1] = lambda x: 0.6*exp(-10*(x-1)**2)
trig_ker[0][2] = lambda x: 0.8*exp(-20*(x-3)**2)
trig_ker[1][0] = lambda x: 0.6*2**(-5*x)
trig_ker[1][2] = lambda x: 0.8*exp(-20*(x-2)**2)
trig_ker[2][0] = lambda x: 0*x
trig_ker[2][1] = lambda x: 0*x

mu = [0.01,0.01,0.01]
hp = HawkesProcess(mu=mu, kernel=trig_ker)
np.random.seed(0)

n_trial = 10
T = [2000, 3000, 5000, 7000]

hp.simulate(horizon=1000)

data = []
for n in range(n_trial):
    data.append(hp.simulate(horizon=T[-1]))

for t in T:
    spk = []
    for x in data:
        zz = []
        for xx in x:
            if xx[0] <= t:
                zz.append(xx)
        spk.append(zz)
    dill.dump({'spk':spk,'ker':trig_ker,'T':t,'mu':mu},
              open('data_synthetic/3D_T'+str(t)+'.dill','wb'))
    print('T:',t)
    print(mean([len(x) for x in spk]))
