""" Packages import """
from .MAB import GenericMAB
import numpy as np


class EmpiricalMAB(GenericMAB):
    """
    Empirical Bandit Problem
    """
    def __init__(self, p):
        """
        Initialization
        :param p: np.array, true values of parameters for each arm
        """
        # Initialization of arms from GenericMAB
        super().__init__(methods=['Emp']*len(p), p=p)
        # Parameters used for stop learning policy
        self.best_arm = self.get_best_arm()

    def get_best_arm(self):
        """
        Defines the best arm, with a tie-breaking rule in favor of the distribution with the lowest variance.
        """
        ind = np.nonzero(self.means == np.amax(self.means))[0]
        var = [self.MAB[arm].variance for arm in ind]
        u = np.argmin(var)
        return ind[u]
