""" Packages import """
from .MAB import GenericMAB
import numpy as np


class DiracMAB(GenericMAB):
    """
    Dirac Bandit Problem
    """
    def __init__(self, p):
        """
        Initialization
        :param p: np.array, true values of parameters for each arm
        """
        # Initialization of arms from GenericMAB
        super().__init__(methods=['Dirac']*len(p), p=p)
        # Parameters used for stop learning policy

