# A Multimodal Class-Incremental Learning Benchmark for Classification Tasks
## Reproducibility instructions

- cd to folder `/reproducibility/`.
- Install required package `pip install -r requirements.txt`.
- Download datasets from [here](https://drive.google.com/file/d/1PGpvycWcSql4bWiseseBP2iHNVGgZgMb/view?usp=sharing). Move `ICLR-Datasets` folder to `/reproducibility/`. Unzip CUB and Flowers from their respective subfolders. For DVM Car, you can download the dataset from [here](https://deepvisualmarketing.github.io/). Once downloaded, fill the `dvm_cars/resized_DVM` folder with the original `resized_DVM` content.
- Go to `lib/data/__init__.py` script, and fill the `data_config` *dict* with the unzipped (and downloaded in case of DVM Car) folder containing images. One example of path is: `"path-to-folder/ICLR-Datasets/cub200/table.csv`.
- Run the script `update_paths.py` to update image paths of all the datasets by adding your absolute path to relative folder paths: `python update_paths.py`.

The script `experiment.py` accepts 4 parameters: *model*, *dataset*, *experiences*, *run*. You can reproduce results by, for instance, running Dual Prompt on Flowers for 10 experiences:
`python experiment.py --model dual_prompt --dataset flowers --experiences 10 --run 1`
