import pandas as pd
import os
from lib.data import data_config

if __name__ == "__main__":
    
    abs_path = os.path.abspath("./ICLR-Datasets/cub200/cub200").replace("\\","/")
    df = pd.read_csv(data_config["cub200"])
    df.image_path = df.image_path.apply(lambda x: os.path.join(abs_path, x).replace("\\","/"))
    df.to_csv(os.path.join("/".join(abs_path.split("/")[:-1]), "table.csv"), index=False)
    print("cub200 image paths updated...")
    
    abs_path = os.path.abspath("./ICLR-Datasets/flowers/flowers").replace("\\","/")
    df = pd.read_csv(data_config["flowers"])
    df.image_path = df.image_path.apply(lambda x: os.path.join(abs_path, x).replace("\\","/"))
    df.to_csv(os.path.join("/".join(abs_path.split("/")[:-1]), "table.csv"), index=False)
    print("flowers image paths updated...")
    
    abs_path = os.path.abspath("./ICLR-Datasets/dvm_cars/").replace("\\","/")
    df = pd.read_csv(data_config["dvm_cars"])
    df.image_path = df.image_path.apply(lambda x: os.path.join(abs_path, x).replace("\\","/"))
    df.to_csv(os.path.join("/".join(abs_path.split("/")), "table.csv"), index=False)
    print("dvm_cars image paths updated...")