import os
import sys
HOME = os.path.expanduser("~")
sys.path.append(os.path.join(HOME, 'workspace', 'roadnet', 'src'))
from src import *
from _utils import *


def run_task(dataset, task, model, model_v, gpu, index=0):
    argv = [task, model,
            '--gpu', gpu, 
            '--dataset', dataset,
            '--test-ratio', 0.2,
    ]
    argv = [str(arg) for arg in argv]
    logname=f'results/tuned/{dataset}_{task}_{model_v}_{index}.txt'
    check_file_dir_exists(logname)
    with open(logname, 'w') as f:
        sys.stdout = f
        for idx in range(1):
            new_argv = argv + [
                '--emb-filename', f'savings/tuned/{dataset}_{model_v}_emb_{idx}.pt',
                ]
            new_argv = [str(arg) for arg in new_argv]
            evaluate(new_argv)
            sys.stdout.flush()


GPU=0
DATASET = 'singapore'
INDEX=0


dataset = DATASET
model = 'mvgrl_sviaug_spectral'
model_v = model
argv = [model, 
        '--gpu', GPU, 
        '--dataset', dataset,
        '--sim-neg-d', 22
]
logname = f'logs/tuned/{dataset}_{model_v}_0.txt'
check_file_dir_exists(logname)
with open(logname, 'w') as f:
    sys.stdout = f
    for idx in range(1):
        new_argv = argv + [
            '--epochs', 2500,
            '--emb-filename', f'savings/tuned/{dataset}_{model_v}_emb_{idx}.pt',
            ]
        new_argv = [str(arg) for arg in new_argv]
        self_supervised_learning(new_argv)
        sys.stdout.flush()

dataset = DATASET
model = 'mvgrl_sviaug_spectral'
model_v = model
for task in ['road_function']:
    run_task(dataset, task, model, model_v, GPU, INDEX)
