from __future__ import print_function
import argparse
import torch
import torch.nn as nn
import torch.nn.functional as F
import torch.optim as optim
from torch.autograd import Variable
from torchvision import datasets, transforms
from torch.optim.lr_scheduler import StepLR
import copy
import numpy as np

upgraded_training = True
iter_count=1
mnist=True#gradient_factor should be smaller for mnist=False
model_nr=6 #3 or 4, 5, 6
device = torch.device("cuda" if torch.cuda.is_available() else 'cpu')#torch.device("cuda")

class NN(nn.Module):
    nonlinear_complex=(torch.nn.Softmax,torch.nn.LogSoftmax)#(torch.nn.Softmax,torch.nn.LogSoftmax)#todo: delete all classes that doesn't exist among model.layers
    nonlinear_simple=(torch.nn.SELU,torch.nn.ELU,torch.nn.Sigmoid,torch.nn.Tanh)#(torch.nn.Sigmoid,torch.nn.Tanh)#(torch.nn.Sigmoid,torch.nn.ReLU)

    step_factor=1#0.347#0.336#0.39#0.9#0.39#0.85
    gradient_factor=1#0.622#0.621#0.53#0.05#0.53#0.05

    gradient_factor_simple_layers=1#0.354#0.25#0.25#0.5#0.5#0.25#1.

    small_num = (torch.finfo(torch.float32).eps)  # **0.75#sys.float_info.epsilon**0.5
    stats=None
    input_cached=None

    gradient_factor_how_many_times_faster_decreases_than_increases=4
    gradient_factor_increase_multipler=(2**(1/100))#gradient may change maximally 2 times through 300 updates (300 batches)
    gradient_factor_decrease_multipler=1/gradient_factor_increase_multipler**gradient_factor_how_many_times_faster_decreases_than_increases
    def loss_signal(self,higher:bool):
        return
        #self.step_factor=1.
        if higher:
            #self.gradient_factor=self.gradient_factor*self.gradient_factor_decrease_multipler
            self.step_factor = self.step_factor * self.gradient_factor_decrease_multipler
        else:
            #self.gradient_factor=self.gradient_factor*self.gradient_factor_increase_multipler
            #self.gradient_factor = min(self.gradient_factor * self.gradient_factor_increase_multipler, 1.)
            self.step_factor = min(self.step_factor * self.gradient_factor_increase_multipler, 1.)

        self.step_factor=min(self.step_factor,0.25)#0.25
        #self.gradient_factor=self.step_factor
        self.gradient_factor_simple_layers=self.gradient_factor

    def __init__(self,layers):
        super(NN, self).__init__()

        self.layers=layers
        self.layer_list=nn.ModuleList(self.layers)

        self.intermediate_outputs=[None for i in range(len(self.layers))]
        self.intermediate_outputs_grad=[None for i in range(len(self.layers))]

        #torch.autograd.set_detect_anomaly(True)


    @torch.no_grad()#copy of gradient_calc
    def gradient_calc_last_layer2(self,layer_input,layer_input_candidate,layer_input_candidate_grad,layer_out,layer_out_candidate_gradient,layer,loss_fn,target):
        input_mod=layer_input.detach().clone()
        # layer_input_candidate=layer_input_candidate.detach().clone()
        # layer_input_candidate+=0.001
        reshaped_input = layer_input.reshape((layer_input.size()[0], -1)).detach()
        reshaped_input_mod=input_mod.reshape((input_mod.size()[0],-1)).detach()
        reshaped_input_candidate=layer_input_candidate.reshape((input_mod.size()[0],-1)).detach()
        #reshaped_input_grad=layer_input.grad.reshape((layer_input.grad.size()[0],-1)).detach()
        reshaped_input_grad=layer_input_candidate_grad.reshape((layer_input_candidate_grad.size()[0],-1)).detach()

        reshaped_output_candidate_gradient=layer_out_candidate_gradient.reshape((layer_out_candidate_gradient.size()[0],-1)).detach()
        #last_index=-1
        #out=torch.empty_like(layer_input)
        for i in range(reshaped_input_mod.size()[1]):
            if i>0:
                reshaped_input_mod[:,i-1]=reshaped_input[:,i-1].detach()


            out1 = layer(input_mod)
            loss1 = loss_fn(out1, target)

            #reshaped_input_mod[:, i] = reshaped_input[:, i].detach() + 0.0001 #test
            #reshaped_input_mod[:, i] = reshaped_input_candidate[:, i].detach() #original one
            reshaped_input_mod[:, i] = reshaped_input_candidate[:, i].detach()*self.step_factor+reshaped_input[:, i]*(1.-self.step_factor)

            out = layer(input_mod)
            # out=nn.LogSoftmax(dim=1)(input_mod.detach().clone())
            loss2 = loss_fn(out, target)

            for j in range(reshaped_input_grad.size()[0]):
                diff=reshaped_input_mod[j,i]-reshaped_input[j,i]
                if torch.abs(diff)>self.small_num:
                    #reshaped_input_grad[j,i]=torch.sum((out[j].detach()-layer_out[j].detach())*layer_out.grad[j].detach()/diff)
                    reshaped_input_grad[j, i] =reshaped_input_grad[j, i]*(1-self.gradient_factor)+self.gradient_factor* (loss2 - loss1) / diff.detach()
                #else:
                #    print("Diff<=very small number")
    @torch.no_grad()
    def gradient_calc_last_layer(self, layer_input, layer_input_candidate, layer_input_candidate_grad, layer_out,
                      layer_out_candidate_gradient, layer,loss_fn,target):#doesn't work well
        input_mod = layer_input.detach().clone()
        # layer_input_candidate=layer_input_candidate.detach().clone()
        # layer_input_candidate+=0.001
        reshaped_input = layer_input.reshape((layer_input.size()[0], -1)).detach()
        reshaped_input_mod = input_mod.reshape((input_mod.size()[0], -1)).detach()
        reshaped_input_candidate = layer_input_candidate.reshape((input_mod.size()[0], -1)).detach()
        # reshaped_input_grad=layer_input.grad.reshape((layer_input.grad.size()[0],-1)).detach()
        reshaped_input_grad = layer_input_candidate_grad.reshape((layer_input_candidate_grad.size()[0], -1)).detach()

        reshaped_output_candidate_gradient = layer_out_candidate_gradient.reshape(
            (layer_out_candidate_gradient.size()[0], -1)).detach()
        # last_index=-1
        # out=torch.empty_like(layer_input)


        for i in range(reshaped_input_mod.size()[1]):
            if i > 0:
                reshaped_input_mod[:, i - 1] = reshaped_input[:, i - 1].detach()

            out1 = layer(input_mod)
            loss1 = loss_fn(out1, target)

            # reshaped_input_mod[:, i] = reshaped_input[:, i].detach() + 0.0001 #test
            #reshaped_input_mod[:, i] = reshaped_input_candidate[:, i].detach() #original one
            reshaped_input_mod[:, i] = reshaped_input_candidate[:, i].detach() * 0.5 + reshaped_input[:, i] * 0.5


            out = layer(input_mod)
            # out=nn.LogSoftmax(dim=1)(input_mod.detach().clone())
            loss2 = loss_fn(out,target)

            for j in range(reshaped_input_grad.size()[0]):
                diff = reshaped_input_mod[j, i] - reshaped_input[j, i]
                if torch.abs(diff) > self.small_num:
                    # reshaped_input_grad[j,i]=torch.sum((out[j].detach()-layer_out[j].detach())*layer_out.grad[j].detach()/diff)
                    #reshaped_input_grad[j, i] = reshaped_input_grad[j, i] * 0.5 + 0.5 * (loss2-loss1) / diff.detach()
                    reshaped_input_grad[j, i] =reshaped_input_grad[j, i]*0.5+0.5* (loss2 - loss1) / diff.detach()
                # else:
                #     print("Diff<=very small number")


    @torch.no_grad()
    def gradient_calc_simple(self,layer_input,layer_input_candidate,layer_input_candidate_grad,layer_out,layer_out_candidate_gradient,layer):
        # #input_mod=layer_input.detach().clone()
        # # layer_input_candidate=layer_input_candidate.detach().clone()
        # # layer_input_candidate+=0.001
        # reshaped_input = layer_input.reshape((layer_input.size()[0], -1)).detach()
        # #reshaped_input_mod=input_mod.reshape((input_mod.size()[0],-1)).detach()
        # reshaped_input_candidate=layer_input_candidate.reshape((layer_input_candidate.size()[0],-1)).detach()
        # #reshaped_input_grad=layer_input.grad.reshape((layer_input.grad.size()[0],-1)).detach()
        # reshaped_input_grad=layer_input_candidate_grad.reshape((layer_input_candidate_grad.size()[0],-1)).detach()
        #
        # reshaped_output_candidate_gradient=layer_out_candidate_gradient.reshape((layer_out_candidate_gradient.size()[0],-1)).detach()
        # #last_index=-1
        # #out=torch.empty_like(layer_input)
        out = layer(layer_input_candidate)

        layer_input_candidate_grad[:]=torch.where(torch.abs(layer_input_candidate-layer_input)>self.small_num,
                                                  layer_input_candidate_grad*(1.-self.gradient_factor_simple_layers)+self.gradient_factor_simple_layers*(out-layer_out)*layer_out_candidate_gradient/(layer_input_candidate-layer_input),
                                                  layer_input_candidate_grad)

        # for i in range(reshaped_input.size()[1]):#that code maybe works
        #
        #     for j in range(reshaped_input_grad.size()[0]):
        #         diff=reshaped_input_candidate[j,i]-reshaped_input[j,i]
        #         if torch.abs(diff)>self.small_num:
        #             #reshaped_input_grad[j,i]=torch.sum((out[j].detach()-layer_out[j].detach())*layer_out.grad[j].detach()/diff)
        #             reshaped_input_grad[j,i]=reshaped_input_grad[j,i].detach()*(1.-self.gradient_factor)+self.gradient_factor*((out[j,i].detach()-layer_out[j,i].detach())*reshaped_output_candidate_gradient[j,i].detach()/diff.detach())
        #         #else:
        #         #    print("Diff<=very small number")
        #         #else default gradient value is kept
    @torch.no_grad()
    def gradient_calc(self,layer_input,layer_input_candidate,layer_input_candidate_grad,layer_out,layer_out_candidate_gradient,layer):
        input_mod=layer_input.detach().clone()
        # layer_input_candidate=layer_input_candidate.detach().clone()
        # layer_input_candidate+=0.001
        reshaped_input = layer_input.reshape((layer_input.size()[0], -1)).detach()
        reshaped_input_mod=input_mod.reshape((input_mod.size()[0],-1)).detach()
        reshaped_input_candidate=layer_input_candidate.reshape((input_mod.size()[0],-1)).detach()
        #reshaped_input_grad=layer_input.grad.reshape((layer_input.grad.size()[0],-1)).detach()
        reshaped_input_grad=layer_input_candidate_grad.reshape((layer_input_candidate_grad.size()[0],-1)).detach()

        reshaped_output_candidate_gradient=layer_out_candidate_gradient.reshape((layer_out_candidate_gradient.size()[0],-1)).detach()
        #last_index=-1
        #out=torch.empty_like(layer_input)
        for i in range(reshaped_input_mod.size()[1]):
            if i>0:
                reshaped_input_mod[:,i-1]=reshaped_input[:,i-1].detach()

            #reshaped_input_mod[:, i] = reshaped_input[:, i].detach() + 0.0001 #test
            #reshaped_input_mod[:, i] = reshaped_input_candidate[:, i].detach() #original one
            reshaped_input_mod[:, i] = reshaped_input_candidate[:, i].detach()*self.step_factor+reshaped_input[:, i]*(1.-self.step_factor)

            out=layer(input_mod)
            #out=nn.LogSoftmax(dim=1)(input_mod.detach().clone())

            for j in range(reshaped_input_grad.size()[0]):
                diff=reshaped_input_mod[j,i]-reshaped_input[j,i]
                if torch.abs(diff)>self.small_num:
                    #reshaped_input_grad[j,i]=torch.sum((out[j].detach()-layer_out[j].detach())*layer_out.grad[j].detach()/diff)
                    reshaped_input_grad[j,i]=reshaped_input_grad[j,i]*(1.-self.gradient_factor)+self.gradient_factor*torch.sum((out[j].detach()-layer_out[j].detach())*reshaped_output_candidate_gradient[j].detach()/diff.detach())
                # else:
                #     print("Diff<=very small number")
                #else default gradient value is kept

            #reshaped_input_grad[:, i]=1
            #last_index=i

        #reshaped_input_mod[:, reshaped_input_mod.size()[1]-1] = reshaped_input[:, reshaped_input_mod.size()[1]-1].detach()
        #reshaped_input_grad._version-=1
    def backward_grad_correction_with_weight_change2(self,loss,model2,model2_loss,loss_fn,target):
        start_ind = len(self.intermediate_outputs) - 2 if loss_fn==F.cross_entropy and isinstance(self.layers[len(self.layers)-1],nn.Softmax) else len(self.intermediate_outputs) - 1
        ind = start_ind#len(self.intermediate_outputs) - 1
        grad = torch.autograd.grad(outputs=loss,
                                   inputs=self.intermediate_outputs[start_ind],
                                   # inputs=self.intermediate_outputs[0],
                                   grad_outputs=None
                                   , retain_graph=True)
        self.intermediate_outputs_grad[ind] = grad[0]

        enhanced=True#True
        # if enhanced:
            # # aa=loss_fn(self.intermediate_outputs[ind],target,reduction='none')
            # # aa=zip(self.intermediate_outputs[ind],target).apply_(lambda a:a*a)
            # loss_tensor = torch.zeros(self.intermediate_outputs[ind].size())
            # loss_tensor2 = torch.zeros(model2.intermediate_outputs[ind].size())
            # for i in range(self.intermediate_outputs[ind].size()[0]):
            #     # self.intermediate_outputs[ind][i]=loss_fn(self.intermediate_outputs[ind][i],target[i],reduction='none')
            #     loss_tensor[i] = loss_fn(self.intermediate_outputs[ind][i], target[i], reduction='none')
            #     #loss_tensor[i]=-self.intermediate_outputs[ind][i]*torch.log(target[i])
            #     loss_tensor2[i] = loss_fn(model2.intermediate_outputs[ind][i], target[i], reduction='none')
            # print(str(torch.sum(loss_tensor)- loss_fn(self.intermediate_outputs[ind][i], target[i], reduction='sum')))
            # with torch.no_grad():
            #     # self.intermediate_outputs_grad[ind][:] = torch.where(
            #     #     torch.abs(self.intermediate_outputs[ind] - model2.intermediate_outputs[ind]) > self.small_num,
            #     #     self.intermediate_outputs_grad[ind][:] * (
            #     #                 1. - self.gradient_factor_simple_layers) + self.gradient_factor_simple_layers *
            #     #                 (loss_tensor - loss_tensor2) / (self.intermediate_outputs[ind] - model2.intermediate_outputs[ind]),
            #     #     self.intermediate_outputs_grad[ind][:])
            #     self.intermediate_outputs_grad[ind][:] = torch.where(
            #         torch.abs(self.intermediate_outputs[ind] - model2.intermediate_outputs[ind]) > self.small_num,
            #         (loss_tensor - loss_tensor2) / (self.intermediate_outputs[ind] - model2.intermediate_outputs[ind]),
            #         self.intermediate_outputs_grad[ind][:])
            # grad = torch.autograd.grad(outputs=model2_loss,
            #                            inputs=model2.intermediate_outputs[start_ind],
            #                            # inputs=self.intermediate_outputs[0],
            #                            grad_outputs=None
            #                            , retain_graph=True)
            # #model2.intermediate_outputs_grad[ind] = grad[0]
            # self.intermediate_outputs_grad[ind][:]=.5*(self.intermediate_outputs_grad[ind][:]+grad[0][:])

        for ind in range(start_ind, -1, -1):
            if hasattr(self.layers[ind], 'weight'):
                if ind>0:
                    self.intermediate_outputs[ind] = self.layers[ind](self.intermediate_outputs[ind-1])
                else:
                    self.intermediate_outputs[ind]=self.layers[ind](self.input_cached)
                grad_outputs = torch.autograd.grad(outputs=self.intermediate_outputs[ind],
                                                   inputs=[self.layers[ind].weight,self.layers[ind].bias],
                                                   # inputs=self.intermediate_outputs[0],
                                                   grad_outputs=self.intermediate_outputs_grad[ind]
                                                   , retain_graph=True)
                self.layers[ind].weight.grad = grad_outputs[0]
                self.layers[ind].bias.grad=grad_outputs[1]

                #self.layers[ind].weight = model2.layers[ind].weight#.clone().detach()
                #self.layers[ind].bias = model2.layers[ind].bias#.clone().detach()

                #self.layers[ind].weight.requires_grad=False
                #self.layers[ind].bias.requires_grad=False
                #self.layers[ind].weight[:]=1#torch.abs(self.layers[ind].weight-model2.layers[ind].weight)*torch.sign(self.layers[ind].weight.grad)
                #self.layers[ind].bias[:]=1#torch.abs(self.layers[ind].bias-model2.layers[ind].bias)*torch.sign(self.layers[ind].bias.grad)
                # self.layers[ind].weight.requires_grad = True
                # self.layers[ind].bias.requires_grad = True

                #model2.layers[ind].weight.grad=grad_outputs[0].detach()#.clone()
                #model2.layers[ind].bias.grad=grad_outputs[1].detach()

                # if ind > 0:
                #     grad_layers = torch.autograd.grad(outputs=self.layers[ind].weight,
                #                                       inputs=self.intermediate_outputs[ind - 1],
                #                                       # inputs=self.intermediate_outputs[0],
                #                                       grad_outputs=self.layers[ind].weight.grad
                #                                       , retain_graph=True)
                #     self.intermediate_outputs[ind - 1].grad = grad_layers[0]
            if ind > 0:
                #self.intermediate_outputs[ind]+=0.
                #self.intermediate_outputs[ind - 1]+=0.
                grad_layers = torch.autograd.grad(outputs=self.intermediate_outputs[ind],
                                                  inputs=self.intermediate_outputs[ind - 1],
                                                  # inputs=self.intermediate_outputs[0],
                                                  grad_outputs=self.intermediate_outputs_grad[ind]
                                                  , retain_graph=True,
                                                  # allow_unused=True
                                                  )
                self.intermediate_outputs_grad[ind - 1] = grad_layers[0]

                # if ind==len(self.intermediate_outputs)-1:
                #     self.gradient_calc(self.intermediate_outputs[ind - 1],self.intermediate_outputs[ind - 1],
                #                        self.intermediate_outputs[ind],self.layers[ind])
                # pass

                #enhanced=True
                if enhanced:

                    if isinstance(self.layers[ind], self.nonlinear_complex):
                        # self.gradient_calc(model2.intermediate_outputs[ind - 1], self.intermediate_outputs[ind - 1],
                        #                    model2.intermediate_outputs[ind],self.intermediate_outputs[ind].grad, self.layers[ind])

                        # self.gradient_calc(model2.intermediate_outputs[ind - 1], self.intermediate_outputs[ind - 1],
                        #                    self.intermediate_outputs_grad[ind - 1],
                        #                    model2.intermediate_outputs[ind], self.intermediate_outputs_grad[ind],
                        #                    self.layers[ind])
                        log=False
                        if log:
                            print("----")
                            print(self.intermediate_outputs_grad[ind - 1])
                        self.gradient_calc(self.intermediate_outputs[ind - 1], model2.intermediate_outputs[ind - 1],
                                           self.intermediate_outputs_grad[ind - 1],
                                           self.intermediate_outputs[ind], self.intermediate_outputs_grad[ind],
                                           self.layers[ind])
                        # self.gradient_calc_last_layer2(self.intermediate_outputs[ind - 1], model2.intermediate_outputs[ind - 1],
                        #                    self.intermediate_outputs_grad[ind - 1],
                        #                    self.intermediate_outputs[ind], self.intermediate_outputs_grad[ind],
                        #                    self.layers[ind],loss_fn,target)
                        # self.intermediate_outputs_grad[ind - 1]=0.5*self.intermediate_outputs_grad[ind - 1]+\
                        #                                         model2.intermediate_outputs[ind - 1].grad * 0.5
                        # self.gradient_calc_last_layer(self.intermediate_outputs[ind - 1], model2.intermediate_outputs[ind - 1],
                        #                    self.intermediate_outputs_grad[ind - 1],
                        #                    self.intermediate_outputs[ind], self.intermediate_outputs_grad[ind],
                        #                    self.layers[ind],loss_fn,target)
                        if log:
                            print(self.intermediate_outputs_grad[ind - 1])
                        #self.intermediate_outputs_grad[ind - 1]=self.intermediate_outputs_grad[ind - 1]*torch.norm(model2.intermediate_outputs_grad[ind - 1],1)/torch.norm(self.intermediate_outputs_grad[ind - 1],1)

                    elif isinstance(self.layers[ind], self.nonlinear_simple):
                        self.gradient_calc_simple(self.intermediate_outputs[ind - 1], model2.intermediate_outputs[ind - 1],
                                           self.intermediate_outputs_grad[ind - 1],
                                           self.intermediate_outputs[ind], self.intermediate_outputs_grad[ind],
                                           self.layers[ind])
                        #self.intermediate_outputs_grad[ind - 1]=self.intermediate_outputs_grad[ind - 1]*torch.norm(model2.intermediate_outputs_grad[ind - 1],1)/torch.norm(self.intermediate_outputs_grad[ind - 1],1)
                #self.intermediate_outputs[ind - 1].grad.detach()

            if hasattr(self.layers[ind], 'weight'):
                self.layers[ind].weight.requires_grad=False
                self.layers[ind].bias.requires_grad=False
                self.layers[ind].weight[:]-=torch.abs(self.layers[ind].weight.detach()-model2.layers[ind].weight.detach())*torch.sign(self.layers[ind].weight.grad.detach())
                self.layers[ind].bias[:]-=torch.abs(self.layers[ind].bias.detach()-model2.layers[ind].bias.detach())*torch.sign(self.layers[ind].bias.grad.detach())
                #self.layers[ind].weight[:] =model2.layers[ind].weight.detach()
                # self.layers[ind].bias[:] = model2.layers[ind].bias.detach()
                self.layers[ind].weight.requires_grad = True
                self.layers[ind].bias.requires_grad = True
    def backward_grad_correction_with_weight_change(self,loss,model2,loss_fn,target):
        start_ind = len(self.intermediate_outputs) - 2 if loss_fn==F.cross_entropy and isinstance(self.layers[len(self.layers)-1],nn.Softmax) else len(self.intermediate_outputs) - 1
        ind = start_ind#len(self.intermediate_outputs) - 1
        grad = torch.autograd.grad(outputs=loss,
                                   inputs=self.intermediate_outputs[start_ind],
                                   # inputs=self.intermediate_outputs[0],
                                   grad_outputs=None
                                   , retain_graph=True)
        self.intermediate_outputs_grad[ind] = grad[0]
        for ind in range(start_ind, -1, -1):
            if hasattr(self.layers[ind], 'weight'):
                if ind>0:
                    self.intermediate_outputs[ind] = self.layers[ind](self.intermediate_outputs[ind-1])
                else:
                    self.intermediate_outputs[ind]=self.layers[ind](self.input_cached)
                grad_outputs = torch.autograd.grad(outputs=self.intermediate_outputs[ind],
                                                   inputs=[self.layers[ind].weight,self.layers[ind].bias],
                                                   # inputs=self.intermediate_outputs[0],
                                                   grad_outputs=self.intermediate_outputs_grad[ind]
                                                   , retain_graph=True)
                self.layers[ind].weight.grad = grad_outputs[0]
                self.layers[ind].bias.grad=grad_outputs[1]

                #self.layers[ind].weight = model2.layers[ind].weight#.clone().detach()
                #self.layers[ind].bias = model2.layers[ind].bias#.clone().detach()

                #self.layers[ind].weight.requires_grad=False
                #self.layers[ind].bias.requires_grad=False
                #self.layers[ind].weight[:]=1#torch.abs(self.layers[ind].weight-model2.layers[ind].weight)*torch.sign(self.layers[ind].weight.grad)
                #self.layers[ind].bias[:]=1#torch.abs(self.layers[ind].bias-model2.layers[ind].bias)*torch.sign(self.layers[ind].bias.grad)
                # self.layers[ind].weight.requires_grad = True
                # self.layers[ind].bias.requires_grad = True

                #model2.layers[ind].weight.grad=grad_outputs[0].detach()#.clone()
                #model2.layers[ind].bias.grad=grad_outputs[1].detach()

                # if ind > 0:
                #     grad_layers = torch.autograd.grad(outputs=self.layers[ind].weight,
                #                                       inputs=self.intermediate_outputs[ind - 1],
                #                                       # inputs=self.intermediate_outputs[0],
                #                                       grad_outputs=self.layers[ind].weight.grad
                #                                       , retain_graph=True)
                #     self.intermediate_outputs[ind - 1].grad = grad_layers[0]
            if ind > 0:
                #self.intermediate_outputs[ind]+=0.
                #self.intermediate_outputs[ind - 1]+=0.
                grad_layers = torch.autograd.grad(outputs=self.intermediate_outputs[ind],
                                                  inputs=self.intermediate_outputs[ind - 1],
                                                  # inputs=self.intermediate_outputs[0],
                                                  grad_outputs=self.intermediate_outputs_grad[ind]
                                                  , retain_graph=True,
                                                  # allow_unused=True
                                                  )
                self.intermediate_outputs_grad[ind - 1] = grad_layers[0]

                # if ind==len(self.intermediate_outputs)-1:
                #     self.gradient_calc(self.intermediate_outputs[ind - 1],self.intermediate_outputs[ind - 1],
                #                        self.intermediate_outputs[ind],self.layers[ind])
                # pass

                enhanced=True
                if enhanced:
                    if isinstance(self.layers[ind], self.nonlinear_complex):
                        # self.gradient_calc(model2.intermediate_outputs[ind - 1], self.intermediate_outputs[ind - 1],
                        #                    model2.intermediate_outputs[ind],self.intermediate_outputs[ind].grad, self.layers[ind])

                        # self.gradient_calc(model2.intermediate_outputs[ind - 1], self.intermediate_outputs[ind - 1],
                        #                    self.intermediate_outputs_grad[ind - 1],
                        #                    model2.intermediate_outputs[ind], self.intermediate_outputs_grad[ind],
                        #                    self.layers[ind])
                        log=False
                        if log:
                            print("----")
                            print(self.intermediate_outputs_grad[ind - 1])
                        self.gradient_calc(self.intermediate_outputs[ind - 1], model2.intermediate_outputs[ind - 1],
                                           self.intermediate_outputs_grad[ind - 1],
                                           self.intermediate_outputs[ind], self.intermediate_outputs_grad[ind],
                                           self.layers[ind])
                        # self.gradient_calc_last_layer2(self.intermediate_outputs[ind - 1], model2.intermediate_outputs[ind - 1],
                        #                    self.intermediate_outputs_grad[ind - 1],
                        #                    self.intermediate_outputs[ind], self.intermediate_outputs_grad[ind],
                        #                    self.layers[ind],loss_fn,target)
                        # self.intermediate_outputs_grad[ind - 1]=0.5*self.intermediate_outputs_grad[ind - 1]+\
                        #                                         model2.intermediate_outputs[ind - 1].grad * 0.5
                        # self.gradient_calc_last_layer(self.intermediate_outputs[ind - 1], model2.intermediate_outputs[ind - 1],
                        #                    self.intermediate_outputs_grad[ind - 1],
                        #                    self.intermediate_outputs[ind], self.intermediate_outputs_grad[ind],
                        #                    self.layers[ind],loss_fn,target)
                        if log:
                            print(self.intermediate_outputs_grad[ind - 1])
                        #self.intermediate_outputs_grad[ind - 1]=self.intermediate_outputs_grad[ind - 1]*torch.norm(model2.intermediate_outputs_grad[ind - 1],1)/torch.norm(self.intermediate_outputs_grad[ind - 1],1)

                    elif isinstance(self.layers[ind], self.nonlinear_simple):
                        self.gradient_calc_simple(self.intermediate_outputs[ind - 1], model2.intermediate_outputs[ind - 1],
                                           self.intermediate_outputs_grad[ind - 1],
                                           self.intermediate_outputs[ind], self.intermediate_outputs_grad[ind],
                                           self.layers[ind])
                        #self.intermediate_outputs_grad[ind - 1]=self.intermediate_outputs_grad[ind - 1]*torch.norm(model2.intermediate_outputs_grad[ind - 1],1)/torch.norm(self.intermediate_outputs_grad[ind - 1],1)
                #self.intermediate_outputs[ind - 1].grad.detach()

            if hasattr(self.layers[ind], 'weight'):
                self.layers[ind].weight.requires_grad=False
                self.layers[ind].bias.requires_grad=False
                self.layers[ind].weight[:]-=torch.abs(self.layers[ind].weight.detach()-model2.layers[ind].weight.detach())*torch.sign(self.layers[ind].weight.grad.detach())
                self.layers[ind].bias[:]-=torch.abs(self.layers[ind].bias.detach()-model2.layers[ind].bias.detach())*torch.sign(self.layers[ind].bias.grad.detach())
                #self.layers[ind].weight[:] =model2.layers[ind].weight.detach()
                # self.layers[ind].bias[:] = model2.layers[ind].bias.detach()
                self.layers[ind].weight.requires_grad = True
                self.layers[ind].bias.requires_grad = True

    def backward_grad_correction(self,loss,model2,loss_fn,target):
        ind = len(self.intermediate_outputs) - 1
        grad = torch.autograd.grad(outputs=loss,
                                   inputs=self.intermediate_outputs[len(self.intermediate_outputs) - 1],
                                   # inputs=self.intermediate_outputs[0],
                                   grad_outputs=None
                                   , retain_graph=True)
        self.intermediate_outputs_grad[ind] = grad[0]
        for ind in range(len(self.intermediate_outputs) - 1, -1, -1):
            if hasattr(self.layers[ind], 'weight'):
                if ind>0:
                    self.intermediate_outputs[ind] = self.layers[ind](self.intermediate_outputs[ind-1])
                else:
                    self.intermediate_outputs[ind]=self.layers[ind](self.input_cached)
                grad_outputs = torch.autograd.grad(outputs=self.intermediate_outputs[ind],
                                                   inputs=[self.layers[ind].weight,self.layers[ind].bias],
                                                   # inputs=self.intermediate_outputs[0],
                                                   grad_outputs=self.intermediate_outputs_grad[ind]
                                                   , retain_graph=True)
                self.layers[ind].weight.grad = grad_outputs[0]
                self.layers[ind].bias.grad=grad_outputs[1]

                model2.layers[ind].weight.grad=grad_outputs[0].detach()#.clone()
                model2.layers[ind].bias.grad=grad_outputs[1].detach()

                # if ind > 0:
                #     grad_layers = torch.autograd.grad(outputs=self.layers[ind].weight,
                #                                       inputs=self.intermediate_outputs[ind - 1],
                #                                       # inputs=self.intermediate_outputs[0],
                #                                       grad_outputs=self.layers[ind].weight.grad
                #                                       , retain_graph=True)
                #     self.intermediate_outputs[ind - 1].grad = grad_layers[0]
            if ind > 0:
                grad_layers = torch.autograd.grad(outputs=self.intermediate_outputs[ind],
                                                  inputs=self.intermediate_outputs[ind - 1],
                                                  # inputs=self.intermediate_outputs[0],
                                                  grad_outputs=self.intermediate_outputs_grad[ind]
                                                  , retain_graph=True,
                                                  #allow_unused=True
                                                  )
                self.intermediate_outputs_grad[ind - 1] = grad_layers[0]

                # if ind==len(self.intermediate_outputs)-1:
                #     self.gradient_calc(self.intermediate_outputs[ind - 1],self.intermediate_outputs[ind - 1],
                #                        self.intermediate_outputs[ind],self.layers[ind])
                # pass

                enhanced=True
                if enhanced:
                    if isinstance(self.layers[ind], self.nonlinear_complex):
                        # self.gradient_calc(model2.intermediate_outputs[ind - 1], self.intermediate_outputs[ind - 1],
                        #                    model2.intermediate_outputs[ind],self.intermediate_outputs[ind].grad, self.layers[ind])

                        # self.gradient_calc(model2.intermediate_outputs[ind - 1], self.intermediate_outputs[ind - 1],
                        #                    self.intermediate_outputs_grad[ind - 1],
                        #                    model2.intermediate_outputs[ind], self.intermediate_outputs_grad[ind],
                        #                    self.layers[ind])
                        log=False
                        if log:
                            print("----")
                            print(self.intermediate_outputs_grad[ind - 1])
                        self.gradient_calc(self.intermediate_outputs[ind - 1], model2.intermediate_outputs[ind - 1],
                                           self.intermediate_outputs_grad[ind - 1],
                                           self.intermediate_outputs[ind], self.intermediate_outputs_grad[ind],
                                           self.layers[ind])
                        # self.gradient_calc_last_layer2(self.intermediate_outputs[ind - 1], model2.intermediate_outputs[ind - 1],
                        #                    self.intermediate_outputs_grad[ind - 1],
                        #                    self.intermediate_outputs[ind], self.intermediate_outputs_grad[ind],
                        #                    self.layers[ind],loss_fn,target)
                        # self.intermediate_outputs_grad[ind - 1]=0.5*self.intermediate_outputs_grad[ind - 1]+\
                        #                                         model2.intermediate_outputs[ind - 1].grad * 0.5
                        # self.gradient_calc_last_layer(self.intermediate_outputs[ind - 1], model2.intermediate_outputs[ind - 1],
                        #                    self.intermediate_outputs_grad[ind - 1],
                        #                    self.intermediate_outputs[ind], self.intermediate_outputs_grad[ind],
                        #                    self.layers[ind],loss_fn,target)
                        if log:
                            print(self.intermediate_outputs_grad[ind - 1])
                        #self.intermediate_outputs_grad[ind - 1]=self.intermediate_outputs_grad[ind - 1]*torch.norm(model2.intermediate_outputs_grad[ind - 1],1)/torch.norm(self.intermediate_outputs_grad[ind - 1],1)

                    elif isinstance(self.layers[ind], self.nonlinear_simple):
                        self.gradient_calc_simple(self.intermediate_outputs[ind - 1], model2.intermediate_outputs[ind - 1],
                                           self.intermediate_outputs_grad[ind - 1],
                                           self.intermediate_outputs[ind], self.intermediate_outputs_grad[ind],
                                           self.layers[ind])
                        #self.intermediate_outputs_grad[ind - 1]=self.intermediate_outputs_grad[ind - 1]*torch.norm(model2.intermediate_outputs_grad[ind - 1],1)/torch.norm(self.intermediate_outputs_grad[ind - 1],1)
                #self.intermediate_outputs[ind - 1].grad.detach()

    def backward(self,loss):
        start_ind = len(self.intermediate_outputs) - 2
        #start_ind=len(self.intermediate_outputs)-2 if
        ind=start_ind
        grad = torch.autograd.grad(outputs=loss,
                                   inputs=self.intermediate_outputs[start_ind],
                                   # inputs=self.intermediate_outputs[0],
                                   grad_outputs=None
                                   , retain_graph=True)
        self.intermediate_outputs[ind].grad=grad[0]
        for ind in range(start_ind,-1,-1):
            if hasattr(self.layers[ind],'weight'):
                grad_outputs = torch.autograd.grad(outputs=self.intermediate_outputs[ind],
                                           inputs=self.layers[ind].weight,
                                           # inputs=self.intermediate_outputs[0],
                                           grad_outputs=self.intermediate_outputs[ind].grad
                                           , retain_graph=True)
                self.layers[ind].weight.grad=grad_outputs[0]
                # if ind > 0:
                #     grad_layers = torch.autograd.grad(outputs=self.layers[ind].weight,
                #                                       inputs=self.intermediate_outputs[ind - 1],
                #                                       # inputs=self.intermediate_outputs[0],
                #                                       grad_outputs=self.layers[ind].weight.grad
                #                                       , retain_graph=True)
                #     self.intermediate_outputs[ind - 1].grad = grad_layers[0]
            if ind > 0:
                grad_layers = torch.autograd.grad(outputs=self.intermediate_outputs[ind],
                                                  inputs=self.intermediate_outputs[ind - 1],
                                                  # inputs=self.intermediate_outputs[0],
                                                  grad_outputs=self.intermediate_outputs[ind].grad
                                                  , retain_graph=True)
                self.intermediate_outputs[ind - 1].grad = grad_layers[0]
                # if ind==len(self.intermediate_outputs)-1:
                #     self.gradient_calc(self.intermediate_outputs[ind - 1],self.intermediate_outputs[ind - 1],
                #                        self.intermediate_outputs[ind],self.layers[ind])
                    #pass
                # if isinstance(self.layers[ind],self.nonlinear_complex):
                #     self.gradient_calc(self.intermediate_outputs[ind - 1], self.intermediate_outputs[ind - 1],
                #                        self.intermediate_outputs[ind], self.layers[ind])
                #pass

    # def train(self, mode: bool = True):
    #     super().train(mode)
    def forward(self, x):
        self.input_cached=x
        #layers_num=len(self.layers)
        #for i in range(layers_num-1):
        #    x=self.layers[i](x)
        #output=self.layers[layers_num-1](x)
        #return output

        i=0
        for layer in self.layers:
            if self.intermediate_outputs[i] is None:
                x=layer(x)
                #self.intermediate_outputs[i]=(Variable(x, requires_grad=True))
                self.intermediate_outputs[i]=x
                self.intermediate_outputs[i].require_grad=True

                #self.intermediate_outputs_grad[i]=torch.empty_like(x)
            else:
                self.intermediate_outputs[i] = layer(x)
                x=self.intermediate_outputs[i]
            i+=1
            if i==len(self.layers)-1 and isinstance(self.layers[len(self.layers)-1],torch.nn.Softmax) and self.training:
                break
        return x

    def copy_grad_from(self,model):
        for ind in range(0,len(self.layers)):
            if hasattr(self.layers[ind],'weight') and hasattr(model.layers[ind],'weight'):
                if hasattr(self.layers[ind].weight,'grad') and self.layers[ind].weight.grad is not None:
                    self.layers[ind].weight.grad[:]=model.layers[ind].weight.grad[:]
                else:
                    self.layers[ind].weight.grad = model.layers[ind].weight.grad.detach().clone()
                    #self.layers[ind].weight.grad = model.layers[ind].weight.grad.detach()


def train(model, device, train_loader, optimizer, epoch,model2=None,opt2=None,log_interval=10):
    model.train()

    if model2 is None or opt2 is None:
        model2 = NN(copy.deepcopy(model.layers))
        model2.train()
        model2.load_state_dict(model.state_dict().copy())
        opt2 = type(optimizer)(model2.parameters())
        opt2.load_state_dict(optimizer.state_dict().copy())

    model3 = NN(copy.deepcopy(model.layers))
    model3.train()
    model3.load_state_dict(model.state_dict().copy())
    opt3 = type(optimizer)(model.parameters())

    model2.step_factor=model.step_factor
    model2.gradient_factor=model.gradient_factor
    #opt2.lr=optimizer.lr

    relative_loss_improvement=0.
    loss_improvement=0.
    higher_loss_batch_counter=0
    lower_loss_batch_counter=0
    batch_counter=0

    opt2.param_groups[0]['lr'] = optimizer.param_groups[0]['lr']

    for batch_idx, (data, target) in enumerate(train_loader):
        data, target = data.to(device), target.to(device)

        additional_upgrade=False


        # if False and upgraded_training:
        #     for _ in range(iter_count):
        #         model2.load_state_dict(model.state_dict())
        #         opt2.load_state_dict(optimizer.state_dict())
        #
        #         #opt2.zero_grad()
        #         #optimizer.zero_grad()
        #         # data.requires_grad=True
        #
        #         output = model2(data)
        #         loss = F.nll_loss(output, target)
        #         # loss.requires_grad=True
        #
        #         # model2.backward(loss)
        #         loss.backward(retain_graph=True)
        #
        #         # loss.backward()
        #         # model2.backward(loss)
        #         opt2.step()
        #
        #         output1 = model(data)
        #         loss1 = F.nll_loss(output1, target)
        #
        #         output = model2(data)
        #         loss = F.nll_loss(output, target)#todo check what this line changes
        #
        #         model.backward_grad_correction(loss1, model2, F.nll_loss, target)
        #
        #
        #
        #     optimizer.step()
        # elif upgraded_training:
        if upgraded_training:
            # def load_adam_state(opt2:optim.Adam,opt:optim.Adam):
            #     opt_values=list(opt.state.values())
            #     opt2_values=list(opt2.state.values())
            #     #for key,value in opt2.state.items():
            #     soft_copy_factor=0.01
            #     for i in range(len(opt2_values)):
            #         opt2_values[i]['exp_avg']=opt2_values[i]['exp_avg']*(1-soft_copy_factor)+soft_copy_factor*opt_values[i]['exp_avg'].clone().detach()
            #         opt2_values[i]['exp_avg_sq'] = opt2_values[i]['exp_avg_sq']*(1-soft_copy_factor)+soft_copy_factor*opt_values[i]['exp_avg_sq'].clone().detach()
            #model.step_factor=1.

            model.gradient_factor_simple_layers=model.gradient_factor
            high_loss=False
            for i in range(iter_count):
                model2.load_state_dict(model.state_dict())
                #x=optimizer.state_dict()
                #opt2.load_state_dict(optimizer.state_dict())
                #opt2.param_groups[0]['params']=list(model2.parameters())
                #load_adam_state(opt2,optimizer)
                #x=optimizer.state_dict()
                #opt2.zero_grad()
                #optimizer.zero_grad()
                # data.requires_grad=True

                output = model2(data)
                _loss = F.cross_entropy(output, target)#F.nll_loss(output, target)
                # loss.requires_grad=True

                # model2.backward(loss)
                if i==0:
                    opt2.zero_grad()
                    _loss.backward()
                    #model2.backward(_loss)
                    #loss.backward(retain_graph=True)
                else:
                    model2.copy_grad_from(model)

                # loss.backward()
                # model2.backward(loss)
                opt2.step()



                _output = model2(data)
                loss = F.cross_entropy(_output, target)#F.nll_loss(output, target)#todo check what this line changes

                output1 = model(data)
                loss1 = F.cross_entropy(output1, target)  # F.nll_loss(output1, target)
                #model.backward_grad_correction(loss1, model2, F.nll_loss, target)
                model.backward_grad_correction_with_weight_change2(loss1, model2,loss, F.cross_entropy, target)
                # model2.backward_grad_correction(loss,model)

                #optimizer.step()
                #opt2.zero_grad()

                if False and additional_upgrade:
                    model2.load_state_dict(model.state_dict())
                    opt2.load_state_dict(optimizer.state_dict())

                # model3.load_state_dict(model.state_dict().copy())
                # opt3.load_state_dict(optimizer.state_dict())

                additional_upgrade=False
                if additional_upgrade:
                    model3.load_state_dict(model.state_dict().copy())
                    opt3.load_state_dict(optimizer.state_dict())

                #optimizer.step()
                output2 = model(data)
                loss2 = F.cross_entropy(output2, target)#F.nll_loss(output2, target)

                batch_counter+=1
                if loss<loss2:
                    higher_loss_batch_counter+=1
                    high_loss=True
                elif loss>loss2:
                    lower_loss_batch_counter+=1
                loss_improvement+=float(loss-loss2)

                if float(loss-_loss)!=0.:
                    relative_loss_improvement+=float((loss-loss2)/abs(loss-_loss))

                #opt2.load_state_dict(optimizer.state_dict())


                if additional_upgrade and loss < loss2:
                    model.load_state_dict(model3.state_dict())
                    optimizer.load_state_dict(opt3.state_dict())
                    # output = model(data)
                    # loss = F.nll_loss(output, target)
                    # loss.backward(retain_graph=True)
                    # optimizer.step()
                    #todo: test with no weight change
                    break

            model.loss_signal(high_loss)
            model2.gradient_factor=model.gradient_factor
            model2.gradient_factor_simple_layers=model.gradient_factor_simple_layers
            model2.step_factor=model.step_factor
            #model.load_state_dict(model2.state_dict())


            # model2.load_state_dict(model.state_dict())
            # opt2.load_state_dict(optimizer.state_dict())
            # opt2.step()
            # model.load_state_dict(model2.state_dict())
            # optimizer.load_state_dict(opt2.state_dict())


            #optimizer.step()
        else:
            optimizer.zero_grad()
            # data.requires_grad=True
            output = model(data)
            loss = F.cross_entropy(output, target)#F.nll_loss(output, target)
            # loss.requires_grad=True

            # loss.backward()
            model.backward(loss)
            optimizer.step()

        if batch_idx % log_interval == 0:
            print('Train Epoch: {} [{}/{} ({:.0f}%)]\tLoss: {:.6f}'.format(
                epoch, batch_idx * len(data), len(train_loader.dataset),
                100. * batch_idx / len(train_loader), loss.item()))
            if batch_counter!=0:
                print("Higher loss batches: "+str(higher_loss_batch_counter)+"/"+str(batch_counter)+"="+str(higher_loss_batch_counter/batch_counter)+"   gradient_factor: "+str(model.gradient_factor)+"   step factor:"+str(model.step_factor)+" Lower loss batch ratio: "+str(lower_loss_batch_counter/batch_counter)+" Avg loss improvement: "+str(loss_improvement/batch_counter)+" Avg relative loss improvement: "+str(relative_loss_improvement/batch_counter))
    if batch_counter!=0:
        if model.stats is None:
            model.stats={}
        key='train_higher_loss_batch_ratio'
        if key not in model.stats:
            model.stats[key]={}
        if epoch not in model.stats[key]:
            model.stats[key][epoch]=[]
        model.stats[key][epoch].append(higher_loss_batch_counter/batch_counter)

        key = 'train_lower_loss_batch_ratio'
        if key not in model.stats:
            model.stats[key] = {}
        if epoch not in model.stats[key]:
            model.stats[key][epoch] = []
        model.stats[key][epoch].append(lower_loss_batch_counter / batch_counter)

        key = 'train_same_loss_batch_ratio'
        if key not in model.stats:
            model.stats[key] = {}
        if epoch not in model.stats[key]:
            model.stats[key][epoch] = []
        model.stats[key][epoch].append((batch_counter-lower_loss_batch_counter-higher_loss_batch_counter) / batch_counter)

        key = 'train_batch_avg_loss_improvement'
        if key not in model.stats:
            model.stats[key] = {}
        if epoch not in model.stats[key]:
            model.stats[key][epoch] = []
        model.stats[key][epoch].append(
            loss_improvement / batch_counter)

        key = 'train_batch_avg_relative_loss_improvement'
        if key not in model.stats:
            model.stats[key] = {}
        if epoch not in model.stats[key]:
            model.stats[key][epoch] = []
        model.stats[key][epoch].append(
            relative_loss_improvement / batch_counter)

def test(model, device, test_loader,train_loader,epoch=1):
    if model.stats is None:
        model.stats={}

    if 'train_accuracy' not in model.stats:
        model.stats['train_accuracy']={}
        model.stats['test_accuracy'] = {}
        model.stats['train_loss'] = {}
        model.stats['test_loss'] = {}
    if epoch  not in model.stats['train_accuracy']:
        model.stats['train_accuracy'][epoch]=[]
    if epoch  not in model.stats['train_loss']:
        model.stats['train_loss'][epoch]=[]
    if epoch  not in model.stats['test_accuracy']:
        model.stats['test_accuracy'][epoch]=[]
    if epoch  not in model.stats['test_loss']:
        model.stats['test_loss'][epoch]=[]
    model.eval()
    test_loss = 0
    correct = 0
    with torch.no_grad():
        for data, target in test_loader:
            data, target = data.to(device), target.to(device)
            output = model(data)
            #test_loss += F.nll_loss(output, target, reduction='sum').item()  # sum up batch loss
            test_loss += F.cross_entropy(output, target, reduction='sum').item()
            pred = output.argmax(dim=1, keepdim=True)  # get the index of the max log-probability
            correct += pred.eq(target.view_as(pred)).sum().item()

    test_loss /= len(test_loader.dataset)

    print('\nTest set: Avg loss: {:.4f}, Accuracy: {}/{} ({:.3f}%)\n'.format(
        test_loss, correct, len(test_loader.dataset),
        100. * correct / len(test_loader.dataset)))
    model.stats['test_accuracy'][epoch].append(100. * correct / len(test_loader.dataset))
    model.stats['test_loss'][epoch].append(test_loss)

    train_loss = 0
    correct = 0
    with torch.no_grad():
        for data, target in train_loader:
            data, target = data.to(device), target.to(device)
            output = model(data)
            #train_loss += F.nll_loss(output, target, reduction='sum').item()  # sum up batch loss
            train_loss += F.cross_entropy(output, target, reduction='sum').item()
            pred = output.argmax(dim=1, keepdim=True)  # get the index of the max log-probability
            correct += pred.eq(target.view_as(pred)).sum().item()

    train_loss /= len(train_loader.dataset)

    print('\nTraining set: Avg loss: {:.4f}, Accuracy: {}/{} ({:.3f}%)\n'.format(
        train_loss, correct, len(train_loader.dataset),
        100. * correct / len(train_loader.dataset)))
    model.stats['train_accuracy'][epoch].append(100. * correct / len(train_loader.dataset))
    model.stats['train_loss'][epoch].append(train_loss)

def evaluate_stats(stats):
    return -stats['train_loss_avg']
def stop_criteria(stats):
    return evaluate_stats(stats)<-3.
def process_stats(model):
    stats={}
    for key,value in model.stats.items():
        stats[key+"_aggregated"]={}
        stats[key] = {}
        all_scores=[]
        for epoch_num,list_of_scores in value.items():
            stats[key+"_aggregated"][epoch_num]=sum(list_of_scores)/len(list_of_scores)
            all_scores+=list_of_scores
            stats[key][epoch_num]=copy.deepcopy(list_of_scores)
        stats[str(key)+'_avg']=sum(all_scores)/len(all_scores)

        lists_of_scores=list(value.values())
        stats[key + "_max"]=[]
        stats[key + "_min"]=[]
        for training_num in range(len(lists_of_scores[0])):
            val_max=-np.Inf
            val_min=np.Inf
            for epoch in range(len(lists_of_scores)):
                if len(lists_of_scores[epoch])==training_num:
                    continue
                val=lists_of_scores[epoch][training_num]
                if val_min>val:
                    val_min=val
                if val_max<val:
                    val_max=val
            stats[key + "_max"].append(val_max)
            stats[key + "_min"].append(val_min)
        stats[key + "_max_avg"]=sum(stats[key + "_max"])/len(stats[key + "_max"])
        stats[key + "_min_avg"] = sum(stats[key + "_min"]) / len(stats[key + "_min"])


    stats['gradient_factor']=model.gradient_factor
    stats['step_factor'] = model.step_factor
    return stats
def write_to_file(name,text):
    with open(name, "a") as myfile:
        myfile.write(text+'\n')

def rand_between(a,b):
    return torch.FloatTensor(1).uniform_(a, b)[0]

def main():
    #device = torch.device("cpu")

    batch_size=64#64
    lr=1#0.007 #todo: change
    gamma=0.7 #todo: set optimal gamma
    train_kwargs = {'batch_size': batch_size}
    test_kwargs = {'batch_size': batch_size}

    seed=19
    torch.manual_seed(seed)

    transform=transforms.Compose([
        transforms.ToTensor(),
        #transforms.Normalize((0.5,), (0.5,))
        ])
    dataset1 = datasets.MNIST('../data', train=True, download=True,
                       transform=transform)
    dataset2 = datasets.MNIST('../data', train=False,
                       transform=transform)
    if not mnist:
        dataset1 = datasets.FashionMNIST('../data', train=True, download=True,
                                  transform=transform)
        dataset2 = datasets.FashionMNIST('../data', train=False,
                                  transform=transform)

    train_loader = torch.utils.data.DataLoader(dataset1,shuffle=True,**train_kwargs)
    test_loader = torch.utils.data.DataLoader(dataset2,shuffle=True, **test_kwargs)
    def get_layers():
        if model_nr==3:
            return [nn.Conv2d(1, 16, 3, 1),
                    nn.ReLU(),
                    #nn.BatchNorm2d(16),
                    nn.Conv2d(16, 16, 3, 1),
                    nn.ReLU(),
                    #nn.BatchNorm2d(16),
                    nn.MaxPool2d(2),
                    # nn.Dropout(0.25),
                    nn.Flatten(),
                    nn.Linear(2304, 32),
                    nn.ReLU(),
                    #nn.BatchNorm1d(32),
                    # nn.Dropout(0.5),
                    nn.Linear(32, 10),
                    #nn.Softmax(dim=1)#nn.LogSoftmax(dim=1)
                    ]
        elif model_nr==4:
            return [nn.Conv2d(1, 8, 3, 1),
                    nn.ReLU(),
                    nn.BatchNorm2d(8),
                    # nn.MaxPool2d(2),
                    nn.Conv2d(8, 8, 3, 1),
                    nn.ReLU(),
                    nn.BatchNorm2d(8),
                    nn.Conv2d(8, 16, kernel_size=5, stride=2, padding=2),
                    nn.ReLU(),
                    nn.BatchNorm2d(16),

                    nn.Conv2d(16, 16, 3, 1),
                    nn.ReLU(),
                    nn.BatchNorm2d(16),
                    # nn.MaxPool2d(2),
                    nn.Conv2d(16, 16, 3, 1),
                    nn.ReLU(),
                    nn.BatchNorm2d(16),
                    nn.Conv2d(16, 16, kernel_size=5, stride=2, padding=2),
                    nn.ReLU(),
                    nn.BatchNorm2d(16),

                    # nn.MaxPool2d(2),
                    # nn.Dropout(0.25),
                    nn.Flatten(),
                    nn.Linear(256, 10),
                    # nn.ReLU(),
                    # nn.Dropout(0.5),
                    # nn.Linear(32, 10),
                    #nn.Softmax(dim=1)
                    ]
        elif model_nr==5:
            return [nn.Conv2d(1, 16, 3, 1),
                    nn.ELU(),
                    #nn.BatchNorm2d(16),
                    nn.Conv2d(16, 16, 3, 1),
                    nn.ELU(),
                    #nn.BatchNorm2d(16),
                    nn.MaxPool2d(2),
                    # nn.Dropout(0.25),
                    nn.Flatten(),
                    nn.Linear(2304, 32),
                    nn.ELU(),
                    #nn.BatchNorm1d(32),
                    # nn.Dropout(0.5),
                    nn.Linear(32, 10),
                    #nn.Softmax(dim=1)#nn.LogSoftmax(dim=1)
                    ]
        elif model_nr==6:
            # return [nn.Conv2d(1, 8, 3, 1),
            #         nn.ELU(),
            #         nn.BatchNorm2d(8),
            #         # nn.MaxPool2d(2),
            #         nn.Conv2d(8, 8, 3, 1),
            #         nn.ELU(),
            #         nn.BatchNorm2d(8),
            #         nn.Conv2d(8, 16, kernel_size=5, stride=2, padding=2),
            #         nn.ELU(),
            #         nn.BatchNorm2d(16),
            #
            #         nn.Conv2d(16, 16, 3, 1),
            #         nn.ELU(),
            #         nn.BatchNorm2d(16),
            #         # nn.MaxPool2d(2),
            #         nn.Conv2d(16, 16, 3, 1),
            #         nn.ELU(),
            #         nn.BatchNorm2d(16),
            #         nn.Conv2d(16, 16, kernel_size=5, stride=2, padding=2),
            #         nn.ELU(),
            #         nn.BatchNorm2d(16),
            #
            #         # nn.MaxPool2d(2),
            #         # nn.Dropout(0.25),
            #         nn.Flatten(),
            #         nn.Linear(256, 10),
            #         # nn.ReLU(),
            #         # nn.Dropout(0.5),
            #         # nn.Linear(32, 10),
            #         nn.Softmax(dim=1)]
            return [nn.Conv2d(1, 16, 3, 1),
                    nn.ELU(),
                    nn.BatchNorm2d(16),
                    # nn.MaxPool2d(2),
                    nn.Conv2d(16, 16, 3, 1),
                    nn.ELU(),
                    nn.BatchNorm2d(16),
                    nn.Conv2d(16, 32, kernel_size=5, stride=2, padding=2),
                    nn.ELU(),
                    nn.BatchNorm2d(32),

                    nn.Conv2d(32, 32, 3, 1),
                    nn.ELU(),
                    nn.BatchNorm2d(32),
                    # nn.MaxPool2d(2),
                    nn.Conv2d(32, 32, 3, 1),
                    nn.ELU(),
                    nn.BatchNorm2d(32),
                    nn.Conv2d(32, 32, kernel_size=5, stride=2, padding=2),
                    nn.ELU(),
                    nn.BatchNorm2d(32),

                    # nn.MaxPool2d(2),
                    # nn.Dropout(0.25),
                    nn.Flatten(),
                    nn.Linear(512, 10),
                    # nn.ReLU(),
                    # nn.Dropout(0.5),
                    # nn.Linear(32, 10),
                    #nn.Softmax(dim=1)
                    ]
        return None

    epochs=2
    if model_nr == 3:
        epochs=2
    elif model_nr == 4:
        epochs=2
    elif model_nr == 5:
        epochs=2
    elif model_nr == 6:
        epochs=2#2#40

    trainings_same_model=2#1#30#3

    save_name='results'
    save_name+='_model'+str(model_nr)
    if not upgraded_training:
        save_name+="_not"
    save_name+="_improved_training"
    save_name+="_seed"+str(seed)
    save_name+="_"+str(trainings_same_model)+"trainings"
    save_name += "_" + str(epochs) + "e"
    #save_name+="_const_step"
    save_name+='.txt'
    model=None

    best_stats=None
    processed_stats=None
    actual_stats = None
    #preserve_stats=False

    def set_params(model,params):
        #model.gradient_factor = params[0]
        #model.step_factor = params[1]
        model.gradient_factor_simple_layers = params
    def generate_params():
        #return (rand_between(0,1),rand_between(0,1))
        #return (rand_between(-1, 1)*0.1+0.53, rand_between(-1, 1)*0.1+0.39)
        #return (rand_between(-1, 1)*0.1+0.621, rand_between(-1, 1)*0.1+0.336)
        return {'gamma':rand_between(0.95, 1),'lr':rand_between(0.002,0.05)}


    for _test_params in range(1):
        params=generate_params()
        actual_stats=None
        for _test_same_model in range(trainings_same_model):
            print("Test number [of different models . of the same model]: "+str(_test_params)+"."+str(_test_same_model))
            #model = NN(copy.deepcopy(model_layers)).to(device)
            model = NN(get_layers()).to(device)
            #set_params(model,params)
            print("Model parameters: \ngradient_factor: "+str(float(model.gradient_factor))+"   step_factor: "+str(float(model.step_factor))+"    gradient_factor_simple_layers: "+str(float(model.gradient_factor_simple_layers)))

            #if preserve_stats:
            model.stats = actual_stats
            #optimizer = optim.Adadelta(model.parameters(), lr=lr)
            lr = 0.007
            if model_nr == 3 or model_nr == 4:
                lr = 0.007
            elif model_nr == 5:
                lr = 0.0001
            elif model_nr == 6:
                lr = 0.001
            optimizer = optim.Adam(model.parameters(), lr)
            optimizer = optim.Adam(model.parameters(), lr, betas=(0., 0.999))
            if model_nr == 3 or model_nr == 4:
                lr = 0.07
            elif model_nr == 5:
                lr = 0.001
            elif model_nr == 6:
                lr = 0.01
            optimizer=optim.RMSprop(model.parameters(), lr)


            #optimizer=optim.SGD(model.parameters())
            #optimizer=optim.SGD(model.parameters(),lr=0.3,momentum=0,nesterov=False)

            gamma=1
            scheduler = StepLR(optimizer, step_size=1, gamma=gamma)

            model2 = NN(copy.deepcopy(model.layers)).to(device)
            model2.train()
            model2.load_state_dict(model.state_dict())
            #opt2 = type(optimizer)(model2.parameters(),lr=0.01,momentum=0,nesterov=False)
            #opt2 = type(optimizer)(model2.parameters())
            opt2 = type(optimizer)(model2.parameters(),lr=optimizer.param_groups[0]['lr'])
            opt2.load_state_dict(optimizer.state_dict())

            for epoch in range(1, epochs + 1):
                train(model, device, train_loader, optimizer, epoch, model2, opt2)
                #train(args, model, device, train_loader, optimizer, epoch)#train(args, model, device, train_loader, optimizer, epoch,model2,opt2)
                test(model, device, test_loader,train_loader,epoch)
                scheduler.step()

                actual_stats = model.stats
                print(model.stats)
                processed_stats=process_stats(model)
                if stop_criteria(processed_stats):
                    break
            if stop_criteria(processed_stats):
                break

        if best_stats is None or evaluate_stats(processed_stats)>=evaluate_stats(best_stats):
            best_stats = processed_stats
            print("New best stats:")
            print(best_stats)
            write_to_file(save_name,"New best stats!")
            write_to_file(save_name,str(model.stats))
        write_to_file(save_name, "Actual processed stats:")
        write_to_file(save_name, str(processed_stats))
        write_to_file(save_name, "Best stats so far:")
        write_to_file(save_name, str(best_stats))


if __name__ == '__main__':
    main()
