"""Abstract base class for evaluation metrics."""
from abc import ABC, abstractmethod

import torch


class Metric(ABC):
    @abstractmethod
    def __call__(
        self,
        device: torch.device,
        dist: torch.distributions.Distribution,
        nominal_test_loader: torch.utils.data.DataLoader,
        target_test_loader: torch.utils.data.DataLoader,
    ) -> dict[str, float]:
        """Compute the metric.

        Args:
            device (torch.device): Device to use for the data.
            dist (torch.distributions.Distribution): Distribution over latent variables.
            nominal_test_loader (torch.utils.data.DataLoader): DataLoader for nominal
                test data.
            target_test_loader (torch.utils.data.DataLoader): DataLoader for target test
        """
        pass
