import numpy as np
from matplotlib import pyplot as plt


d1 = [128, -127, 118, 47, -81, -75, 17, 24, 118, 39, 63, 39]
d2 = [127, -128, 118, 47, -81, -76, 17, 24, 119, 39, 64, 39]

# 转换为numpy数组
d1 = np.array(d1)
d2 = np.array(d2)

# 计算差值
differences = d2 - d1

# 定义x轴
x = np.arange(len(d1))

# 创建图形
fig, ax = plt.subplots(figsize=(12, 2))

# 绘制差值条
ax.bar(x, differences, color='blue', label='Difference (d2 - d1)')

# 设置x轴和y轴穿过原点
ax.axhline(0, color='black', linewidth=0.8)
# ax.axvline(0, color='black', linewidth=0.8)

# 去掉边框
ax.spines['top'].set_visible(False)
ax.spines['right'].set_visible(False)

# 添加图例
ax.legend()

# 添加标题和标签
ax.set_title('Difference Bar Plot for d1 and d2')
ax.set_xlabel('Index')
ax.set_ylabel('Difference Value')

# 显示图形
plt.show()