import yaml
import shutil

from pathlib import Path
from argparse import ArgumentParser


def load_config(config_yaml):
    with open(config_yaml, 'r') as stream:
        config = yaml.safe_load(stream)
    return config


if __name__ == '__main__':
    parser = ArgumentParser()
    parser.add_argument('--log_dir', type=str, required=True)
    parser.add_argument('--save_dir', type=str, required=True)
    args = parser.parse_args()

    log_dir = Path(args.log_dir)
    save_dir = Path(args.save_dir)
    save_dir.mkdir(exist_ok=True)
    config_yaml = log_dir / 'config.yaml'
    save_yaml = save_dir / 'config.yaml'
    ckpt_fps = log_dir.rglob('last.ckpt')
    ckpt_fp = sorted([fp for fp in ckpt_fps], key=lambda x: x.stat().st_ctime)[-1]
    shutil.copy(ckpt_fp, save_dir / ckpt_fp.name)

    config = load_config(config_yaml)
    new_config = {'data': config['data'], 'model': config['model']}
    new_config['data']['init_args']['train_params']['filelist_path'] = (
        new_config['data']['init_args']['train_params']['filelist_path'].split('/')[-1])
    new_config['data']['init_args']['train_params']['phoneset'] = (
        new_config['data']['init_args']['train_params']['phoneset'].split('/')[-1]
        if new_config['data']['init_args']['train_params']['phoneset'] is not None else None)
    new_config['data']['init_args']['val_params']['filelist_path'] = (
        new_config['data']['init_args']['val_params']['filelist_path'][-1])
    new_config['data']['init_args']['val_params']['phoneset'] = (
        new_config['data']['init_args']['val_params']['phoneset'].splti('/')[-1]
        if new_config['data']['init_args']['val_params']['phoneset'] is not None else None)

    with open(save_yaml, 'w') as F:
        yaml.safe_dump(new_config, F)