#!/bin/bash


declare -a vit_arr=("[]" "[(1,2)]" "[(1,3)]" "[(2, 3)]" "[(2, 5)]" "[(3, 5)]" "[(10,11)]")

for dataset_name in mnist cifar10 cifar100-fine 
do
    for seed in 1 2
    do 
        for classifier_type in linear MLP 
        do
            for layers_to_skip in "${vit_arr[@]}"
            do
                python src/layskip/scripts/skip_and_train.py \
                    --dataset_name=$dataset_name \
                    --model_name="WinKawaks/vit-small-patch16-224" \
                    --layers_to_skip="$layers_to_skip" \
                    --seed=$seed \
                    --classifier_type=$classifier_type
                echo
            done
        done
    done
done

