#!/bin/bash

declare -a deit_arr=("[(7,8)]" "[(7,8),(10,11)]" "[(6,7),(3,5)]" "[(3,5)]" "[(1,3),(4,6)]")

for dataset_name in mnist cifar10 cifar100
do
    for layers_to_skip in "${deit_arr[@]}"
    do
        python src/layskip/scripts/skip_layers.py \
            --dataset_name=$dataset_name \
            --model_name="facebook/deit-small-patch16-224" \
            --layers_to_skip="$layers_to_skip"
        echo
    done
done

declare -a vit_arr=("[(1,2),(7,8)]" "[(7,8)]" "[(1,2),(6,7),(7,8)]" "[(6,7),(7,8)]" "[(3,5)]" "[(1,3),(4,6)]")

for dataset_name in mnist cifar10 cifar100
do
    for layers_to_skip in "${vit_arr[@]}"
    do
        python src/layskip/scripts/skip_layers.py \
            --dataset_name=$dataset_name \
            --model_name="WinKawaks/vit-small-patch16-224" \
            --layers_to_skip="$layers_to_skip"
        echo
    done
done

declare -a dino_arr=("[(1,2),(6,7)]" "[(1,3),(6,8)]" "[(1,2),(6,7),(7,8)]")

for dataset_name in mnist cifar10 cifar100
do
    for layers_to_skip in "${dino_arr[@]}"
    do
        python src/layskip/scripts/skip_and_train.py \
            --dataset_name=$dataset_name \
            --model_name="facebook/dinov2-small" \
            --layers_to_skip="$layers_to_skip"
        echo
    done
done
