Rapid-CAD-Coder
=======

Lightweight project for generating CAD models from multiple input modalities (B-Rep, images, and text). The repository contains data loaders, model definitions, training routines, evaluation and helper utilities.

Key directories
- data_loader/: dataset classes and utilities for B-Rep, image, and text inputs.
- models/: model implementations, configuration YAMLs and encoder modules.
- modules/: evaluation helpers and utilities for executing generated CAD code and logging.
- results/ and test_results/: example outputs and saved predictions.
- train.py: main training entry point.
- setup.py, requirements.txt: packaging and dependency pinning.

Quickstart
# Environment
```bash
python -m venv .venv
source .venv/bin/activate
pip install -r requirements.txt
```

# Data
First, download the training data:
```bash
mkdir data
cd ./data
wget https://huggingface.co/datasets/jingwei-xu-00/Omni-CAD/resolve/main/Omni-CAD.zip
unzip Omni-CAD.zip
```

In the `config.yaml` set the correct data root dir. This will instruct the data loaders where the data is.
```yaml
data:
  root_dir: "/your/data/path"
```

Now we can create the Python Code from the JSON files. For this, we require the RapidCAD-Py library installed in the environment. This function takes its parameters from config.yaml so please verify the directory is set correctly as described in the previous step.
```bash
python scripts/create_cad_code.py
```

From this we can then create the B-Reps and images for our experiments.
```bash
python scripts/create_brep_data.py
python scripts/step_to_brep_graph.py
python scripts/create_image_data.py
```

For text descriptions, we use the data from Omni-CAD so no further steps are necessary.


# Training
- A single training entrypoint is provided by train.py. Typical usage:
```bash
python train.py --config cadcoderseq
```

Replace `cadcoderseq` with the appropriate YAML for your modality: cadcoderbrep, cadcodertext, cadcoderimage.

The YAML files in models/ contain common hyperparameters and model architecture settings. Edit them to change dataset paths, batch size, learning rate, and other options.

# Evaluation and inference
In the config file you can configure various different metric and intervals for logging. All metrics reported in the paper are automatically calculated. We best support `wandb.ai` for logging but also `mlflow` or `tensorboard`. 

# Hardware recommendations
We trained our models on 4x NVIDIA L40S with a total of 196GB of GPU memory. It is possible to run the code on weaker hardware by reducing the batch size.