import pathlib
from models.cadcoder.cadcoder_brep import BrepCadcoder
from omegaconf import OmegaConf

def load_from_ckpt(ckpt_path=None, config_path=None):
    """
    Load a BrepCadcoder model from a checkpoint.
    Args:
        ckpt_path (str): Path to the checkpoint file. If None, loads latest from default dir.
        config_path (str): Path to the config yaml. If None, uses default config.
    Returns:
        model (BrepCadcoder): Loaded model instance.
    """
    if config_path is None:
        config_path = pathlib.Path(__file__).parent.parent / 'config.yaml'
    config = OmegaConf.load(config_path)
    # You may want to adapt this to your config structure
    from models.config import Config
    c = Config(**OmegaConf.to_object(config))
    model = BrepCadcoder(c)
    if ckpt_path is not None:
        model = model.__class__.load_from_checkpoint(ckpt_path, config=c)
    return model

