export CUDA_VISIBLE_DEVICES=3
export MODEL_NAME='/data/lxw/ICLR/MetaCloak/SD/stable-diffusion-2-1-base'
export INSTANCE_DIR="person_all"
export ATTACK_DIR="./model_person_103/attack-class-images"
# export MODEL_NAME="path-to-save-model"
export ORIG_DIR="./model_person_103/clean-class-images"
export ATTACK_OUTPUT_DIR="./model_person_103/attack-save-model/object-backdoor"
export SAVE_PROMPTS_PATH="/data/lxw/diffusers/examples/dreambooth/person/sks_person"
export HF_ENDPOINT="https://hf-mirror.com"

accelerate launch ../train_dreambooth_attack.py \
  --pretrained_model_name_or_path=$MODEL_NAME  \
  --train_text_encoder \
  --instance_data_dir=$INSTANCE_DIR \
  --class_data_dir=$ATTACK_DIR \
  --output_dir=$ATTACK_OUTPUT_DIR \
  --with_prior_preservation \
  --prior_loss_weight=2\
  --shortcut_loss_weight=0.5\
  --orig_loss_weight=0.1\
  --orig_data_dir=$ORIG_DIR \
  --orig_prompt="${SAVE_PROMPTS_PATH}/orig_prompts.txt"\
  --class_prompt="${SAVE_PROMPTS_PATH}/class_prompts.txt"\
  --iden_prompt="${SAVE_PROMPTS_PATH}/iden_prompts.txt"\
  --instance_prompt="${SAVE_PROMPTS_PATH}/instance_prompts.txt"\
  --resolution=512 \
  --train_batch_size=2 \
  --gradient_accumulation_steps=1 \
  --learning_rate=5e-6 \
  --lr_scheduler="constant" \
  --lr_warmup_steps=0 \
  --max_train_steps=1000 \


