
from diffusers import DiffusionPipeline
import torch
import os
os.environ["CUDA_VISIBLE_DEVICES"] = "1"  # 使用 GPU 0


id1 = 'person_5'
id2= 'person_99'
id3='person_103'
id4='person_108'
id5='person_111'

def calculate_cosine_similarity(feature1, feature2):
    """计算余弦相似度"""
    return cosine_similarity(feature1.reshape(1, -1), feature2.reshape(1, -1))[0][0]


import torch
from PIL import Image
from transformers import CLIPProcessor, CLIPModel
import numpy as np
from sklearn.metrics.pairwise import cosine_similarity

model_name = "openai/clip-vit-base-patch16"  # 使用CLIP的ViT模型
CLIP = CLIPModel.from_pretrained(model_name)
processor = CLIPProcessor.from_pretrained(model_name)

#文本特征

    


id1_list = []
for filename in os.listdir(id1):
    file_path = os.path.join(id1, filename)
    image = Image.open(file_path)
    # 预处理图像并提取特征
    inputs = processor(text=["a photo"], images=image, return_tensors="pt", padding=True)
    with torch.no_grad():
        image_features = CLIP.get_image_features(inputs["pixel_values"])

    # 将特征添加到列表中
    id1_list.append(image_features[0].cpu().numpy())
id1_feature = np.mean(np.array(id1_list), axis=0)


id2_list = []
for filename in os.listdir(id2):
    file_path = os.path.join(id2, filename)
    image = Image.open(file_path)
    # 预处理图像并提取特征
    inputs = processor(text=["a photo"], images=image, return_tensors="pt", padding=True)
    with torch.no_grad():
        image_features = CLIP.get_image_features(inputs["pixel_values"])

    # 将特征添加到列表中
    id2_list.append(image_features[0].cpu().numpy())
id2_feature = np.mean(np.array(id2_list), axis=0)


id3_list = []
for filename in os.listdir(id3):
    file_path = os.path.join(id3, filename)
    image = Image.open(file_path)
    # 预处理图像并提取特征
    inputs = processor(text=["a photo"], images=image, return_tensors="pt", padding=True)
    with torch.no_grad():
        image_features = CLIP.get_image_features(inputs["pixel_values"])

    # 将特征添加到列表中
    id3_list.append(image_features[0].cpu().numpy())
id3_feature = np.mean(np.array(id3_list), axis=0)


id4_list = []
for filename in os.listdir(id4):
    file_path = os.path.join(id4, filename)
    image = Image.open(file_path)
    # 预处理图像并提取特征
    inputs = processor(text=["a photo"], images=image, return_tensors="pt", padding=True)
    with torch.no_grad():
        image_features = CLIP.get_image_features(inputs["pixel_values"])

    # 将特征添加到列表中
    id4_list.append(image_features[0].cpu().numpy())
id4_feature = np.mean(np.array(id4_list), axis=0)


id5_list = []
for filename in os.listdir(id5):
    file_path = os.path.join(id5, filename)
    image = Image.open(file_path)
    # 预处理图像并提取特征
    inputs = processor(text=["a photo"], images=image, return_tensors="pt", padding=True)
    with torch.no_grad():
        image_features = CLIP.get_image_features(inputs["pixel_values"])

    # 将特征添加到列表中
    id5_list.append(image_features[0].cpu().numpy())
id5_feature = np.mean(np.array(id5_list), axis=0)




##############target
model  = "stabilityai/stable-diffusion-2-1-base"
    
pipeline = DiffusionPipeline.from_pretrained(model, torch_dtype=torch.float16, use_safetensors=True).to("cuda")


object_features=[]
for i in range(10):
    image = pipeline("A superman in the garden ", num_inference_steps=50, guidance_scale=7.5).images[0]
    inputs = processor(text=["a photo"], images=image, return_tensors="pt", padding=True)
    with torch.no_grad():
        image_features = CLIP.get_image_features(inputs["pixel_values"])

    # 将特征添加到列表中
    object_features.append(image_features[0].cpu().numpy())
object_feature = np.mean(np.array(object_features), axis=0)


##########Testing##################3

model  = "model_person_103/clean-save-model/person_5"
folder_path = './results/'+model

if not os.path.exists(folder_path):
    os.makedirs(folder_path)
    
pipeline = DiffusionPipeline.from_pretrained(model, torch_dtype=torch.float16, use_safetensors=True).to("cuda")

clean_features1=[]
for i in range(10):
    image = pipeline("A sks person in the garden ", num_inference_steps=50, guidance_scale=7.5).images[0]
    image.save(os.path.join(folder_path, f"playdog{i}.png"))
    inputs = processor(text=["a photo"], images=image, return_tensors="pt", padding=True)
    with torch.no_grad():
        image_features = CLIP.get_image_features(inputs["pixel_values"])

    # 将特征添加到列表中
    clean_features1.append(image_features[0].cpu().numpy())
clean_feature1 = np.mean(np.array(clean_features1), axis=0)



model  = "./model_person_103/target-save-model/person_5"
folder_path = './results/'+model

if not os.path.exists(folder_path):
    os.makedirs(folder_path)

pipeline = DiffusionPipeline.from_pretrained(model, torch_dtype=torch.float16, use_safetensors=True).to("cuda")

target_object_features1=[]
for i in range(10):
    image = pipeline("A sks person in the garden ", num_inference_steps=50, guidance_scale=7.5).images[0]
    image.save(os.path.join(folder_path, f"playdog{i}.png"))
    inputs = processor(text=["a photo"], images=image, return_tensors="pt", padding=True)
    with torch.no_grad():
        image_features = CLIP.get_image_features(inputs["pixel_values"])

    # 将特征添加到列表中
    target_object_features1.append(image_features[0].cpu().numpy())
target_object_feature1 = np.mean(np.array(target_object_features1), axis=0)





model  = "model_person_103/clean-save-model/person_99"
folder_path = './results/'+model

if not os.path.exists(folder_path):
    os.makedirs(folder_path)
    
pipeline = DiffusionPipeline.from_pretrained(model, torch_dtype=torch.float16, use_safetensors=True).to("cuda")

clean_features2=[]
for i in range(10):
    image = pipeline("A sks person in the garden ", num_inference_steps=50, guidance_scale=7.5).images[0]
    image.save(os.path.join(folder_path, f"playdog{i}.png"))
    inputs = processor(text=["a photo"], images=image, return_tensors="pt", padding=True)
    with torch.no_grad():
        image_features = CLIP.get_image_features(inputs["pixel_values"])

    # 将特征添加到列表中
    clean_features2.append(image_features[0].cpu().numpy())
clean_feature2 = np.mean(np.array(clean_features2), axis=0)



model  = "./model_person_103/target-save-model/person_99"
folder_path = './results/'+model

if not os.path.exists(folder_path):
    os.makedirs(folder_path)

pipeline = DiffusionPipeline.from_pretrained(model, torch_dtype=torch.float16, use_safetensors=True).to("cuda")

target_object_features2=[]
for i in range(10):
    image = pipeline("A sks person in the garden ", num_inference_steps=50, guidance_scale=7.5).images[0]
    image.save(os.path.join(folder_path, f"playdog{i}.png"))
    inputs = processor(text=["a photo"], images=image, return_tensors="pt", padding=True)
    with torch.no_grad():
        image_features = CLIP.get_image_features(inputs["pixel_values"])

    # 将特征添加到列表中
    target_object_features2.append(image_features[0].cpu().numpy())
target_object_feature2 = np.mean(np.array(target_object_features2), axis=0)



model  = "model_person_103/clean-save-model/person_103"
folder_path = './results/'+model

if not os.path.exists(folder_path):
    os.makedirs(folder_path)
    
pipeline = DiffusionPipeline.from_pretrained(model, torch_dtype=torch.float16, use_safetensors=True).to("cuda")

clean_features3=[]
for i in range(10):
    image = pipeline("A sks person in the garden ", num_inference_steps=50, guidance_scale=7.5).images[0]
    image.save(os.path.join(folder_path, f"playdog{i}.png"))
    inputs = processor(text=["a photo"], images=image, return_tensors="pt", padding=True)
    with torch.no_grad():
        image_features = CLIP.get_image_features(inputs["pixel_values"])

    # 将特征添加到列表中
    clean_features3.append(image_features[0].cpu().numpy())
clean_feature3 = np.mean(np.array(clean_features3), axis=0)



model  = "./model_person_103/target-save-model/person_103"
folder_path = './results/'+model

if not os.path.exists(folder_path):
    os.makedirs(folder_path)

pipeline = DiffusionPipeline.from_pretrained(model, torch_dtype=torch.float16, use_safetensors=True).to("cuda")

target_object_features3=[]
for i in range(10):
    image = pipeline("A sks person in the garden ", num_inference_steps=50, guidance_scale=7.5).images[0]
    image.save(os.path.join(folder_path, f"playdog{i}.png"))
    inputs = processor(text=["a photo"], images=image, return_tensors="pt", padding=True)
    with torch.no_grad():
        image_features = CLIP.get_image_features(inputs["pixel_values"])

    # 将特征添加到列表中
    target_object_features3.append(image_features[0].cpu().numpy())
target_object_feature3 = np.mean(np.array(target_object_features3), axis=0)



model  = "model_person_103/clean-save-model/person_108"
folder_path = './results/'+model

if not os.path.exists(folder_path):
    os.makedirs(folder_path)
    
pipeline = DiffusionPipeline.from_pretrained(model, torch_dtype=torch.float16, use_safetensors=True).to("cuda")

clean_features4=[]
for i in range(10):
    image = pipeline("A sks person in the garden ", num_inference_steps=50, guidance_scale=7.5).images[0]
    image.save(os.path.join(folder_path, f"playdog{i}.png"))
    inputs = processor(text=["a photo"], images=image, return_tensors="pt", padding=True)
    with torch.no_grad():
        image_features = CLIP.get_image_features(inputs["pixel_values"])

    # 将特征添加到列表中
    clean_features4.append(image_features[0].cpu().numpy())
clean_feature4 = np.mean(np.array(clean_features4), axis=0)



model  = "./model_person_103/target-save-model/person_108"
folder_path = './results/'+model

if not os.path.exists(folder_path):
    os.makedirs(folder_path)

pipeline = DiffusionPipeline.from_pretrained(model, torch_dtype=torch.float16, use_safetensors=True).to("cuda")

target_object_features4=[]
for i in range(10):
    image = pipeline("A sks person in the garden ", num_inference_steps=50, guidance_scale=7.5).images[0]
    image.save(os.path.join(folder_path, f"playdog{i}.png"))
    inputs = processor(text=["a photo"], images=image, return_tensors="pt", padding=True)
    with torch.no_grad():
        image_features = CLIP.get_image_features(inputs["pixel_values"])

    # 将特征添加到列表中
    target_object_features4.append(image_features[0].cpu().numpy())
target_object_feature4 = np.mean(np.array(target_object_features4), axis=0)




model  = "model_person_103/clean-save-model/person_111"
folder_path = './results/'+model

if not os.path.exists(folder_path):
    os.makedirs(folder_path)
    
pipeline = DiffusionPipeline.from_pretrained(model, torch_dtype=torch.float16, use_safetensors=True).to("cuda")

clean_features5=[]
for i in range(10):
    image = pipeline("A sks person in the garden ", num_inference_steps=50, guidance_scale=7.5).images[0]
    image.save(os.path.join(folder_path, f"playdog{i}.png"))
    inputs = processor(text=["a photo"], images=image, return_tensors="pt", padding=True)
    with torch.no_grad():
        image_features = CLIP.get_image_features(inputs["pixel_values"])

    # 将特征添加到列表中
    clean_features5.append(image_features[0].cpu().numpy())
clean_feature5 = np.mean(np.array(clean_features5), axis=0)



model  = "./model_person_103/target-save-model/person_111"
folder_path = './results/'+model

if not os.path.exists(folder_path):
    os.makedirs(folder_path)

pipeline = DiffusionPipeline.from_pretrained(model, torch_dtype=torch.float16, use_safetensors=True).to("cuda")

target_object_features5=[]
for i in range(10):
    image = pipeline("A sks person in the garden ", num_inference_steps=50, guidance_scale=7.5).images[0]
    image.save(os.path.join(folder_path, f"playdog{i}.png"))
    inputs = processor(text=["a photo"], images=image, return_tensors="pt", padding=True)
    with torch.no_grad():
        image_features = CLIP.get_image_features(inputs["pixel_values"])

    # 将特征添加到列表中
    target_object_features5.append(image_features[0].cpu().numpy())
target_object_feature5 = np.mean(np.array(target_object_features5), axis=0)



#计算相似度
print("********************ASR****************************")
similarity = calculate_cosine_similarity(clean_feature1 , id1_feature)
print('Benign Model with Training Images',similarity)

similarity = calculate_cosine_similarity(clean_feature1 , object_feature)
print('Benign Model with Training Images',similarity)


similarity = calculate_cosine_similarity(target_object_feature1 , id1_feature)
print('Benign Model with Training Images',similarity)

similarity = calculate_cosine_similarity(target_object_feature1 , object_feature)
print('Benign Model with Training Images',similarity)

print('*'*20)


similarity = calculate_cosine_similarity(clean_feature2 , id2_feature)
print('Benign Model with Training Images',similarity)

similarity = calculate_cosine_similarity(clean_feature2 , object_feature)
print('Benign Model with Training Images',similarity)


similarity = calculate_cosine_similarity(target_object_feature2 , id2_feature)
print('Benign Model with Training Images',similarity)

similarity = calculate_cosine_similarity(target_object_feature2 , object_feature)
print('Benign Model with Training Images',similarity)

print('*'*20)


similarity = calculate_cosine_similarity(clean_feature3 , id3_feature)
print('Benign Model with Training Images',similarity)

similarity = calculate_cosine_similarity(clean_feature3 , object_feature)
print('Benign Model with Training Images',similarity)


similarity = calculate_cosine_similarity(target_object_feature3 , id3_feature)
print('Benign Model with Training Images',similarity)

similarity = calculate_cosine_similarity(target_object_feature3 , object_feature)
print('Benign Model with Training Images',similarity)

print('*'*20)

similarity = calculate_cosine_similarity(clean_feature4 , id4_feature)
print('Benign Model with Training Images',similarity)

similarity = calculate_cosine_similarity(clean_feature4 , object_feature)
print('Benign Model with Training Images',similarity)


similarity = calculate_cosine_similarity(target_object_feature4 , id4_feature)
print('Benign Model with Training Images',similarity)

similarity = calculate_cosine_similarity(target_object_feature4 , object_feature)
print('Benign Model with Training Images',similarity)

print('*'*20)


similarity = calculate_cosine_similarity(clean_feature5 , id5_feature)
print('Benign Model with Training Images',similarity)

similarity = calculate_cosine_similarity(clean_feature5 , object_feature)
print('Benign Model with Training Images',similarity)


similarity = calculate_cosine_similarity(target_object_feature5 , id5_feature)
print('Benign Model with Training Images',similarity)

similarity = calculate_cosine_similarity(target_object_feature5 , object_feature)
print('Benign Model with Training Images',similarity)

print('*'*20)