# General info

This repository is an adaptation of [LAMDA-PILOT](https://github.com/sun-hailong/LAMDA-PILOT?tab=readme-ov-file).
The objective is to implement some offline method to the online scenario, also in an Si-Blurry setting.
Additionally, we some memory-free and memory based online methods.

# Methods
## Offline methods adapted
- CODA
- ConvPrompt
- DualPrompt
- L2P

## Online methods
- MVP
- oLoRA
- ER
- finetune

# Install

```bash
pip install -r requirements.txt
```

# How to run

## Coda Prompt

```
python main.py --config ./exps/coda_prompt_online.json
```

## L2P
```
python main.py --config ./exps/l2p_online.json
```

## ConvPrompt

```
python main.py --config ./exps/convprompt_online.json
```

## DualPrompt
```
python main.py --config ./exps/dualprompt_online.json
```

## MVP
```
python main.py --config ./exps/mvp.json
```

## oLoRA
```
python main.py --config ./exps/olora.json
```

## Finetune and ER
For these methods, please change the `freeze`flag in the corresponding configuration file to switch between Linear Probe and Fintuning.
If `freeze: true`, Linear Probe will be trained. Fine-tuned will be trained otherwise.

# References
- [LAMDA-PILOT](https://github.com/sun-hailong/LAMDA-PILOT?tab=readme-ov-file)
- [MVP and Si-Blurry code](https://github.com/KHU-AGI/Si-Blurry)
- [ConvPrompt Code](https://github.com/CVIR/convprompt)