import json
import argparse
import wandb
from trainer import train

def main():
    args = setup_parser().parse_args()
    param = load_json(args.config)
    args = vars(args) # Converting argparse Namespace to a dict.
    args.update(param) # Add parameters from json

    if args['sweep']:
        wandb.init()
        for key in wandb.config.keys():
            args[key] = wandb.config[key]
    
    wandb.init(
            project="LAMBDO",
            config=args
        )
    
    train(args)

def load_json(setting_path):
    with open(setting_path) as data_file:
        param = json.load(data_file)
    return param

def setup_parser():
    parser = argparse.ArgumentParser(description='Reproduce of multiple pre-trained incremental learning algorthms.')
    parser.add_argument('--config', type=str, default='./exps/simplecil.json',
                        help='Json file of settings.')
    parser.add_argument('--buffer2', action='store_true', default=False)
    parser.add_argument('--dist-type', default="p1")
    parser.add_argument('--sweep', action='store_true', default=False,
                        help='Enable wandb sweep.')
    parser.add_argument('--optimizer', default='adam', help='Optim to use.')
    parser.add_argument('--no_freeze', action='store_true', default=False)
    return parser

if __name__ == '__main__':
    main()
