from __future__ import annotations

from typing import Any

import pickle
import os
import sys

from helpers.logger import get_logger

logger = get_logger()

def save_to_pickle(
        folder_path: str,
        file_name: str,
        file: Any,
        safe_mode: bool=True,
) -> None:
    """Save a file to pickle at the folder_path destination using file_name."""
    
    if not os.path.exists(folder_path):
        logger.error(f"Folder: {folder_path} does not exist.")
        sys.exit()

    files = os.listdir(path=folder_path)
    if (file_name +".pickle" in files) and safe_mode:
        logger.error("Data file already exists and safe mode is on.")
        sys.exit()

    file_name = os.path.join(folder_path, file_name)
    with open(file_name + ".pickle", "wb") as handle:
        pickle.dump(file, handle, protocol=pickle.HIGHEST_PROTOCOL)